/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.picnic;

import com.jakewharton.crossword.TextCanvas;
import com.jakewharton.crossword.TextKt;
import com.jakewharton.picnic.CellStyle;
import com.jakewharton.picnic.Table;
import com.jakewharton.picnic.TextAlignment;
import com.jakewharton.picnic.TextLayout;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jakewharton/picnic/SimpleLayout;", "Lcom/jakewharton/picnic/TextLayout;", "cell", "Lcom/jakewharton/picnic/Table$PositionedCell;", "(Lcom/jakewharton/picnic/Table$PositionedCell;)V", "leftPadding", "", "topPadding", "draw", "", "canvas", "Lcom/jakewharton/crossword/TextCanvas;", "measureHeight", "measureWidth", "picnic"})
public final class SimpleLayout
implements TextLayout {
    @NotNull
    private final Table.PositionedCell cell;
    private final int leftPadding;
    private final int topPadding;

    public SimpleLayout(@NotNull Table.PositionedCell cell2) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)cell2, (String)"cell");
        this.cell = cell2;
        CellStyle cellStyle = this.cell.getCanonicalStyle();
        if (cellStyle == null) {
            n2 = 0;
        } else {
            Integer n3 = cellStyle.getPaddingLeft();
            n2 = n3 == null ? 0 : n3;
        }
        this.leftPadding = n2;
        CellStyle cellStyle2 = this.cell.getCanonicalStyle();
        if (cellStyle2 == null) {
            n = 0;
        } else {
            Integer n4 = cellStyle2.getPaddingTop();
            n = n4 == null ? 0 : n4;
        }
        this.topPadding = n;
    }

    @Override
    public int measureWidth() {
        int n;
        CellStyle cellStyle = this.cell.getCanonicalStyle();
        if (cellStyle == null) {
            n = 0;
        } else {
            Integer n2 = cellStyle.getPaddingRight();
            n = n2 == null ? 0 : n2;
        }
        Object object = new char[]{'\n'};
        object = StringsKt.split$default((CharSequence)this.cell.getCell().getContent(), (char[])object, (boolean)false, (int)0, (int)6, null);
        int n3 = this.leftPadding + n;
        Iterator iterator = object.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String it = (String)iterator.next();
        boolean bl = false;
        int n4 = TextKt.getVisualWidth((CharSequence)it);
        while (iterator.hasNext()) {
            String it2 = (String)iterator.next();
            $i$a$-maxOf-SimpleLayout$measureWidth$1 = false;
            int n5 = TextKt.getVisualWidth((CharSequence)it2);
            if (n4 >= n5) continue;
            n4 = n5;
        }
        int n6 = n4;
        return n3 + n6;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int measureHeight() {
        void var3_4;
        void $this$count$iv;
        int n;
        CellStyle cellStyle = this.cell.getCanonicalStyle();
        if (cellStyle == null) {
            n = 0;
        } else {
            Integer n2 = cellStyle.getPaddingBottom();
            n = n2 == null ? 0 : n2;
        }
        CharSequence charSequence = this.cell.getCell().getContent();
        int n3 = 1 + this.topPadding + n;
        boolean $i$f$count = false;
        int count$iv = 0;
        void var4_5 = $this$count$iv;
        for (int i = 0; i < var4_5.length(); ++i) {
            char element$iv = var4_5.charAt(i);
            char it = element$iv;
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        void var10_10 = var3_4;
        return n3 + var10_10;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull TextCanvas canvas) {
        int n;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int height = this.measureHeight();
        CellStyle cellStyle = this.cell.getCanonicalStyle();
        TextAlignment textAlignment = cellStyle == null ? null : cellStyle.getAlignment();
        if (textAlignment == null) {
            textAlignment = TextAlignment.TopLeft;
        }
        TextAlignment alignment = textAlignment;
        switch (WhenMappings.$EnumSwitchMapping$0[alignment.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                n = this.topPadding;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n = (canvas.getHeight() - height) / 2 + this.topPadding;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n = canvas.getHeight() - height + this.topPadding;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int top = n;
        char[] cArray = new char[]{'\n'};
        Iterable $this$forEachIndexed$iv = StringsKt.split$default((CharSequence)this.cell.getCell().getContent(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n2;
            void line;
            int n3;
            int n4 = index$iv;
            index$iv = n4 + 1;
            if (n4 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n4;
            boolean bl = false;
            CellStyle cellStyle2 = this.cell.getCanonicalStyle();
            if (cellStyle2 == null) {
                n3 = 0;
            } else {
                Integer n5 = cellStyle2.getPaddingRight();
                n3 = n5 == null ? 0 : n5;
            }
            int lineWidth = this.leftPadding + n3 + TextKt.getVisualWidth((CharSequence)((CharSequence)line));
            switch (WhenMappings.$EnumSwitchMapping$0[alignment.ordinal()]) {
                case 1: 
                case 4: 
                case 7: {
                    n2 = this.leftPadding;
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    n2 = (canvas.getWidth() - lineWidth) / 2 + this.leftPadding;
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    n2 = canvas.getWidth() - lineWidth + this.leftPadding;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int left = n2;
            canvas.write(top + index, left, (String)line);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAlignment.values().length];
            nArray[TextAlignment.TopLeft.ordinal()] = 1;
            nArray[TextAlignment.TopCenter.ordinal()] = 2;
            nArray[TextAlignment.TopRight.ordinal()] = 3;
            nArray[TextAlignment.MiddleLeft.ordinal()] = 4;
            nArray[TextAlignment.MiddleCenter.ordinal()] = 5;
            nArray[TextAlignment.MiddleRight.ordinal()] = 6;
            nArray[TextAlignment.BottomLeft.ordinal()] = 7;
            nArray[TextAlignment.BottomCenter.ordinal()] = 8;
            nArray[TextAlignment.BottomRight.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

