/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.picnic;

import com.jakewharton.picnic.Cell;
import com.jakewharton.picnic.CellStyle;
import com.jakewharton.picnic.IntCounts;
import com.jakewharton.picnic.ModelKt;
import com.jakewharton.picnic.Row;
import com.jakewharton.picnic.TableSection;
import com.jakewharton.picnic.TableStyle;
import com.jakewharton.picnic.TextRendering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002)*B7\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0019\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0086\u0002J\u0018\u0010%\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013J\b\u0010&\u001a\u00020\u0013H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lcom/jakewharton/picnic/Table;", "", "header", "Lcom/jakewharton/picnic/TableSection;", "body", "footer", "cellStyle", "Lcom/jakewharton/picnic/CellStyle;", "tableStyle", "Lcom/jakewharton/picnic/TableStyle;", "(Lcom/jakewharton/picnic/TableSection;Lcom/jakewharton/picnic/TableSection;Lcom/jakewharton/picnic/TableSection;Lcom/jakewharton/picnic/CellStyle;Lcom/jakewharton/picnic/TableStyle;)V", "getBody", "()Lcom/jakewharton/picnic/TableSection;", "getCellStyle", "()Lcom/jakewharton/picnic/CellStyle;", "cellTable", "", "Lcom/jakewharton/picnic/Table$PositionedCell;", "columnCount", "", "getColumnCount", "()I", "getFooter", "getHeader", "positionedCells", "getPositionedCells", "()Ljava/util/List;", "rowCount", "getRowCount", "getTableStyle", "()Lcom/jakewharton/picnic/TableStyle;", "equals", "", "other", "get", "row", "column", "getOrNull", "hashCode", "toString", "", "Builder", "PositionedCell", "picnic"})
public final class Table {
    @Nullable
    private final TableSection header;
    @NotNull
    private final TableSection body;
    @Nullable
    private final TableSection footer;
    @Nullable
    private final CellStyle cellStyle;
    @Nullable
    private final TableStyle tableStyle;
    private final int rowCount;
    private final int columnCount;
    @NotNull
    private final List<PositionedCell> positionedCells;
    @NotNull
    private final List<List<PositionedCell>> cellTable;

    /*
     * WARNING - void declaration
     */
    private Table(TableSection header, TableSection body, TableSection footer, CellStyle cellStyle, TableStyle tableStyle) {
        int n;
        int n2;
        int n3;
        this.header = header;
        this.body = body;
        this.footer = footer;
        this.cellStyle = cellStyle;
        this.tableStyle = tableStyle;
        TableSection tableSection = this.header;
        if (tableSection == null) {
            n3 = 0;
        } else {
            List<Row> list = tableSection.getRows();
            n3 = list == null ? 0 : (n2 = list.size());
        }
        int n4 = n3 + this.body.getRows().size();
        TableSection tableSection2 = this.footer;
        if (tableSection2 == null) {
            n = 0;
        } else {
            List<Row> list = tableSection2.getRows();
            n = list == null ? 0 : (n2 = list.size());
        }
        this.rowCount = n4 + n;
        IntCounts rowSpanCarries = new IntCounts(0, 1, null);
        List positionedCells = new ArrayList();
        List cellTable = new ArrayList();
        int rowIndex = 0;
        Object[] objectArray = new TableSection[]{this.header, this.body, this.footer};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableSection section = (TableSection)element$iv;
            boolean bl = false;
            CellStyle sectionStyle = ModelKt.access$plus(this.getCellStyle(), section.getCellStyle());
            Iterable $this$forEach$iv2 = section.getRows();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Row row2 = (Row)element$iv2;
                boolean bl2 = false;
                CellStyle rowStyle = ModelKt.access$plus(sectionStyle, row2.getCellStyle());
                List cellRow = new ArrayList();
                ((Collection)cellTable).add(cellRow);
                int columnIndex = 0;
                Iterable $this$forEachIndexed$iv = row2.getCells();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void cell2;
                    int n5 = index$iv;
                    index$iv = n5 + 1;
                    if (n5 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Cell cell3 = (Cell)item$iv;
                    int rawColumnIndex = n5;
                    boolean bl3 = false;
                    while (columnIndex < rowSpanCarries.getSize() && rowSpanCarries.get(columnIndex) > 0) {
                        Collection collection = cellRow;
                        Object e = ((List)cellTable.get(rowIndex - 1)).get(columnIndex);
                        collection.add(e);
                        int n6 = columnIndex;
                        int n7 = rowSpanCarries.get(n6);
                        rowSpanCarries.set(n6, n7 + -1);
                        n6 = columnIndex;
                        columnIndex = n6 + 1;
                    }
                    CellStyle canonicalStyle = ModelKt.access$plus(rowStyle, cell2.getStyle());
                    PositionedCell positionedCell = new PositionedCell(rowIndex, columnIndex, (Cell)cell2, canonicalStyle);
                    ((Collection)positionedCells).add(positionedCell);
                    int rowSpan = cell2.getRowSpan();
                    if (!(rowIndex + rowSpan <= this.getRowCount())) {
                        boolean bl4 = false;
                        String string = "Cell " + rawColumnIndex + " in row " + rowIndex + " has rowSpan=" + rowSpan + " but table rowCount=" + this.getRowCount();
                        throw new IllegalArgumentException(string.toString());
                    }
                    int rowSpanCarry = rowSpan - 1;
                    int n8 = cell2.getColumnSpan();
                    int n9 = 0;
                    while (n9 < n8) {
                        int n10;
                        int it = n10 = n9++;
                        boolean bl5 = false;
                        ((Collection)cellRow).add(positionedCell);
                        rowSpanCarries.set(columnIndex, rowSpanCarry);
                        int n11 = columnIndex;
                        columnIndex = n11 + 1;
                    }
                }
                while (columnIndex < rowSpanCarries.getSize()) {
                    if (rowSpanCarries.get(columnIndex) > 0) {
                        Collection collection = cellRow;
                        Object e = ((List)cellTable.get(rowIndex - 1)).get(columnIndex);
                        collection.add(e);
                        int n12 = columnIndex;
                        int n13 = rowSpanCarries.get(n12);
                        rowSpanCarries.set(n12, n13 + -1);
                    } else {
                        cellRow.add(null);
                    }
                    int n14 = columnIndex;
                    columnIndex = n14 + 1;
                }
                int n15 = rowIndex;
                rowIndex = n15 + 1;
            }
        }
        this.columnCount = rowSpanCarries.getSize();
        this.positionedCells = positionedCells;
        this.cellTable = cellTable;
    }

    @Nullable
    public final TableSection getHeader() {
        return this.header;
    }

    @NotNull
    public final TableSection getBody() {
        return this.body;
    }

    @Nullable
    public final TableSection getFooter() {
        return this.footer;
    }

    @Nullable
    public final CellStyle getCellStyle() {
        return this.cellStyle;
    }

    @Nullable
    public final TableStyle getTableStyle() {
        return this.tableStyle;
    }

    @NotNull
    public String toString() {
        return TextRendering.render$default(this, null, null, 3, null);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.header, this.body, this.footer, this.cellStyle, this.tableStyle};
        return ModelKt.access$hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Table && Intrinsics.areEqual((Object)this.header, (Object)((Table)other).header) && Intrinsics.areEqual((Object)this.body, (Object)((Table)other).body) && Intrinsics.areEqual((Object)this.footer, (Object)((Table)other).footer) && Intrinsics.areEqual((Object)this.cellStyle, (Object)((Table)other).cellStyle) && Intrinsics.areEqual((Object)this.tableStyle, (Object)((Table)other).tableStyle);
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final int getColumnCount() {
        return this.columnCount;
    }

    @NotNull
    public final List<PositionedCell> getPositionedCells() {
        return this.positionedCells;
    }

    @Nullable
    public final PositionedCell getOrNull(int row2, int column) {
        List list = (List)CollectionsKt.getOrNull(this.cellTable, (int)row2);
        return list == null ? null : (PositionedCell)CollectionsKt.getOrNull((List)list, (int)column);
    }

    @NotNull
    public final PositionedCell get(int row2, int column) {
        PositionedCell positionedCell = this.cellTable.get(row2).get(column);
        if (positionedCell == null) {
            boolean bl = false;
            String string = "Cell was null";
            throw new IllegalArgumentException(string.toString());
        }
        return positionedCell;
    }

    public /* synthetic */ Table(TableSection header, TableSection body, TableSection footer, CellStyle cellStyle, TableStyle tableStyle, DefaultConstructorMarker $constructor_marker) {
        this(header, body, footer, cellStyle, tableStyle);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/jakewharton/picnic/Table$PositionedCell;", "", "rowIndex", "", "columnIndex", "cell", "Lcom/jakewharton/picnic/Cell;", "canonicalStyle", "Lcom/jakewharton/picnic/CellStyle;", "(IILcom/jakewharton/picnic/Cell;Lcom/jakewharton/picnic/CellStyle;)V", "getCanonicalStyle", "()Lcom/jakewharton/picnic/CellStyle;", "getCell", "()Lcom/jakewharton/picnic/Cell;", "getColumnIndex", "()I", "getRowIndex", "equals", "", "other", "hashCode", "toString", "", "picnic"})
    public static final class PositionedCell {
        private final int rowIndex;
        private final int columnIndex;
        @NotNull
        private final Cell cell;
        @Nullable
        private final CellStyle canonicalStyle;

        public PositionedCell(int rowIndex, int columnIndex, @NotNull Cell cell2, @Nullable CellStyle canonicalStyle) {
            Intrinsics.checkNotNullParameter((Object)cell2, (String)"cell");
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
            this.cell = cell2;
            this.canonicalStyle = canonicalStyle;
        }

        public final int getRowIndex() {
            return this.rowIndex;
        }

        public final int getColumnIndex() {
            return this.columnIndex;
        }

        @NotNull
        public final Cell getCell() {
            return this.cell;
        }

        @Nullable
        public final CellStyle getCanonicalStyle() {
            return this.canonicalStyle;
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.rowIndex, this.columnIndex, this.cell, this.canonicalStyle};
            return ModelKt.access$hash(objectArray);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof PositionedCell && this.rowIndex == ((PositionedCell)other).rowIndex && this.columnIndex == ((PositionedCell)other).columnIndex && Intrinsics.areEqual((Object)this.cell, (Object)((PositionedCell)other).cell) && Intrinsics.areEqual((Object)this.canonicalStyle, (Object)((PositionedCell)other).canonicalStyle);
        }

        @NotNull
        public String toString() {
            return "PositionedCell(rowIndex=" + this.rowIndex + ", colIndex=" + this.columnIndex + ", cell=" + this.cell + ", canonicalStyle=" + this.canonicalStyle + ')';
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\b\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR(\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0003\u001a\u0004\u0018\u00010\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/jakewharton/picnic/Table$Builder;", "", "()V", "<set-?>", "Lcom/jakewharton/picnic/TableSection;", "body", "getBody", "()Lcom/jakewharton/picnic/TableSection;", "setBody", "(Lcom/jakewharton/picnic/TableSection;)V", "Lcom/jakewharton/picnic/CellStyle;", "cellStyle", "getCellStyle", "()Lcom/jakewharton/picnic/CellStyle;", "setCellStyle", "(Lcom/jakewharton/picnic/CellStyle;)V", "footer", "getFooter", "setFooter", "header", "getHeader", "setHeader", "Lcom/jakewharton/picnic/TableStyle;", "tableStyle", "getTableStyle", "()Lcom/jakewharton/picnic/TableStyle;", "setTableStyle", "(Lcom/jakewharton/picnic/TableStyle;)V", "build", "Lcom/jakewharton/picnic/Table;", "picnic"})
    public static final class Builder {
        @Nullable
        private TableSection header;
        @Nullable
        private TableSection body;
        @Nullable
        private TableSection footer;
        @Nullable
        private CellStyle cellStyle;
        @Nullable
        private TableStyle tableStyle;

        @Nullable
        public final TableSection getHeader() {
            return this.header;
        }

        public final /* synthetic */ void setHeader(TableSection tableSection) {
            this.header = tableSection;
        }

        @NotNull
        public final Builder setHeader(@Nullable TableSection header) {
            Builder builder;
            Builder $this$setHeader_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$setHeader_u24lambda_u2d0.setHeader(header);
            return builder;
        }

        @Nullable
        public final TableSection getBody() {
            return this.body;
        }

        public final /* synthetic */ void setBody(TableSection tableSection) {
            this.body = tableSection;
        }

        @NotNull
        public final Builder setBody(@Nullable TableSection body) {
            Builder builder;
            Builder $this$setBody_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$setBody_u24lambda_u2d1.setBody(body);
            return builder;
        }

        @Nullable
        public final TableSection getFooter() {
            return this.footer;
        }

        public final /* synthetic */ void setFooter(TableSection tableSection) {
            this.footer = tableSection;
        }

        @NotNull
        public final Builder setFooter(@Nullable TableSection footer) {
            Builder builder;
            Builder $this$setFooter_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$setFooter_u24lambda_u2d2.setFooter(footer);
            return builder;
        }

        @Nullable
        public final CellStyle getCellStyle() {
            return this.cellStyle;
        }

        public final /* synthetic */ void setCellStyle(CellStyle cellStyle) {
            this.cellStyle = cellStyle;
        }

        @NotNull
        public final Builder setCellStyle(@Nullable CellStyle cellStyle) {
            Builder builder;
            Builder $this$setCellStyle_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$setCellStyle_u24lambda_u2d3.setCellStyle(cellStyle);
            return builder;
        }

        @Nullable
        public final TableStyle getTableStyle() {
            return this.tableStyle;
        }

        public final /* synthetic */ void setTableStyle(TableStyle tableStyle) {
            this.tableStyle = tableStyle;
        }

        @NotNull
        public final Builder setTableStyle(@Nullable TableStyle tableStyle) {
            Builder builder;
            Builder $this$setTableStyle_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$setTableStyle_u24lambda_u2d4.setTableStyle(tableStyle);
            return builder;
        }

        @NotNull
        public final Table build() {
            TableSection tableSection = this.header;
            TableSection tableSection2 = this.body;
            if (tableSection2 == null) {
                TableSection tableSection3 = tableSection;
                boolean bl = false;
                TableSection tableSection4 = tableSection3;
                String string = "Body section is required";
                throw new IllegalStateException(string.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            TableStyle tableStyle = this.tableStyle;
            CellStyle cellStyle = this.cellStyle;
            TableSection tableSection5 = this.footer;
            TableSection tableSection6 = tableSection2;
            TableSection tableSection7 = tableSection;
            return new Table(tableSection7, tableSection6, tableSection5, cellStyle, tableStyle, defaultConstructorMarker);
        }
    }
}

