/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.retrofit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public final class Ok3Client
implements Client {
    private final Call.Factory client;

    public Ok3Client() {
        this(new OkHttpClient());
    }

    public Ok3Client(OkHttpClient client) {
        this((Call.Factory)client);
    }

    public Ok3Client(Call.Factory client) {
        if (client == null) {
            throw new NullPointerException("client == null");
        }
        this.client = client;
    }

    public retrofit.client.Response execute(Request request) throws IOException {
        return Ok3Client.parseResponse(this.client.newCall(Ok3Client.createRequest(request)).execute());
    }

    static okhttp3.Request createRequest(Request request) {
        Request.Builder builder = new Request.Builder().url(request.getUrl()).method(request.getMethod(), Ok3Client.createRequestBody(request.getBody()));
        List headers = request.getHeaders();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            Header header = (Header)headers.get(i);
            String value = header.getValue();
            if (value == null) {
                value = "";
            }
            builder.addHeader(header.getName(), value);
        }
        return builder.build();
    }

    static retrofit.client.Response parseResponse(Response response) {
        return new retrofit.client.Response(response.request().url().toString(), response.code(), response.message(), Ok3Client.createHeaders(response.headers()), Ok3Client.createResponseBody(response.body()));
    }

    private static RequestBody createRequestBody(final TypedOutput body) {
        if (body == null) {
            return null;
        }
        final MediaType mediaType = MediaType.parse((String)body.mimeType());
        return new RequestBody(){

            public MediaType contentType() {
                return mediaType;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                body.writeTo(sink.outputStream());
            }

            public long contentLength() {
                return body.length();
            }
        };
    }

    private static TypedInput createResponseBody(final ResponseBody body) {
        if (body.contentLength() == 0L) {
            return null;
        }
        return new TypedInput(){

            public String mimeType() {
                MediaType mediaType = body.contentType();
                return mediaType == null ? null : mediaType.toString();
            }

            public long length() {
                return body.contentLength();
            }

            public InputStream in() throws IOException {
                return body.byteStream();
            }
        };
    }

    private static List<Header> createHeaders(Headers headers) {
        int size = headers.size();
        ArrayList<Header> headerList = new ArrayList<Header>(size);
        for (int i = 0; i < size; ++i) {
            headerList.add(new Header(headers.name(i), headers.value(i)));
        }
        return headerList;
    }
}

