/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.retrofit2.adapter.reactor;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;
import retrofit2.HttpException;
import retrofit2.Response;

final class BodyFlux<T>
extends Flux<T> {
    private final Publisher<Response<T>> upstream;

    BodyFlux(Publisher<Response<T>> upstream) {
        this.upstream = upstream;
    }

    public void subscribe(CoreSubscriber<? super T> subscriber) {
        this.upstream.subscribe(new BodySubscriber<T>(subscriber));
    }

    private static class BodySubscriber<R>
    implements Subscriber<Response<R>> {
        private final Subscriber<? super R> subscriber;
        private boolean subscriberTerminated;

        BodySubscriber(Subscriber<? super R> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        public void onNext(Response<R> response) {
            if (response.isSuccessful()) {
                this.subscriber.onNext(response.body());
            } else {
                this.subscriberTerminated = true;
                HttpException t = new HttpException(response);
                try {
                    this.subscriber.onError((Throwable)t);
                }
                catch (Throwable inner) {
                    Operators.onErrorDropped((Throwable)inner, (Context)Context.empty());
                }
            }
        }

        public void onError(Throwable throwable) {
            if (!this.subscriberTerminated) {
                this.subscriber.onError(throwable);
            } else {
                AssertionError broken = new AssertionError("This should never happen! Report as a Retrofit bug with the full stacktrace.", throwable);
                Operators.onErrorDropped((Throwable)((Object)broken), (Context)Context.empty());
            }
        }

        public void onComplete() {
            if (!this.subscriberTerminated) {
                this.subscriber.onComplete();
            }
        }
    }
}

