/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.retrofit2.adapter.reactor;

import java.util.function.Consumer;
import reactor.core.Disposable;
import reactor.core.publisher.FluxSink;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

final class EnqueueSinkConsumer<T>
implements Consumer<FluxSink<Response<T>>> {
    private final Call<T> originalCall;

    EnqueueSinkConsumer(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    @Override
    public void accept(FluxSink<Response<T>> sink) {
        Call call = this.originalCall.clone();
        DisposableCallback<T> callback = new DisposableCallback<T>(call, sink);
        sink.onDispose(callback);
        call.enqueue(callback);
    }

    static final class DisposableCallback<T>
    implements Callback<T>,
    Disposable {
        private final Call<T> call;
        private final FluxSink<Response<T>> sink;

        DisposableCallback(Call<T> call, FluxSink<Response<T>> sink) {
            this.call = call;
            this.sink = sink;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            this.sink.next(response);
            this.sink.complete();
        }

        public void onFailure(Call<T> call, Throwable t) {
            this.sink.error(t);
        }

        public void dispose() {
            this.call.cancel();
        }

        public boolean isDisposed() {
            return this.call.isCanceled();
        }
    }
}

