/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.retrofit2.adapter.reactor;

import java.io.IOException;
import java.util.function.Consumer;
import reactor.core.publisher.FluxSink;
import retrofit2.Call;
import retrofit2.Response;

final class ExecuteSinkConsumer<T>
implements Consumer<FluxSink<Response<T>>> {
    private final Call<T> originalCall;

    ExecuteSinkConsumer(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    @Override
    public void accept(FluxSink<Response<T>> sink) {
        Response response;
        Call call = this.originalCall.clone();
        sink.onDispose(() -> ((Call)call).cancel());
        try {
            response = call.execute();
        }
        catch (IOException e) {
            sink.error((Throwable)e);
            return;
        }
        sink.next((Object)response);
        sink.complete();
    }
}

