/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.retrofit2.adapter.reactor;

import com.jakewharton.retrofit2.adapter.reactor.BodyFlux;
import com.jakewharton.retrofit2.adapter.reactor.EnqueueSinkConsumer;
import com.jakewharton.retrofit2.adapter.reactor.ExecuteSinkConsumer;
import com.jakewharton.retrofit2.adapter.reactor.ResultFlux;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;

final class ReactorCallAdapter<R>
implements CallAdapter<R, Object> {
    private final Type responseType;
    private final Scheduler scheduler;
    private final boolean isAsync;
    private final boolean isResult;
    private final boolean isBody;
    private final boolean isMono;

    ReactorCallAdapter(Type responseType, Scheduler scheduler, boolean isAsync, boolean isResult, boolean isBody, boolean isMono) {
        this.responseType = responseType;
        this.scheduler = scheduler;
        this.isAsync = isAsync;
        this.isResult = isResult;
        this.isBody = isBody;
        this.isMono = isMono;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Object adapt(Call<R> call) {
        Consumer<FluxSink<Response<R>>> consumer = this.isAsync ? new EnqueueSinkConsumer<R>(call) : new ExecuteSinkConsumer<R>(call);
        Flux responseFlux = Flux.create(consumer, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.LATEST);
        Flux flux = this.isResult ? new ResultFlux(responseFlux) : (this.isBody ? new BodyFlux(responseFlux) : responseFlux);
        if (this.scheduler != null) {
            flux = flux.subscribeOn(this.scheduler);
        }
        if (this.isMono) {
            return flux.single();
        }
        return flux;
    }
}

