/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.retrofit2.adapter.reactor;

import com.jakewharton.retrofit2.adapter.reactor.ReactorCallAdapter;
import com.jakewharton.retrofit2.adapter.reactor.Result;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class ReactorCallAdapterFactory
extends CallAdapter.Factory {
    private final Scheduler scheduler;
    private final boolean isAsync;

    public static ReactorCallAdapterFactory create() {
        return new ReactorCallAdapterFactory(null, false);
    }

    public static ReactorCallAdapterFactory createAsync() {
        return new ReactorCallAdapterFactory(null, true);
    }

    public static ReactorCallAdapterFactory createWithScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler == null");
        }
        return new ReactorCallAdapterFactory(scheduler, false);
    }

    private ReactorCallAdapterFactory(Scheduler scheduler, boolean isAsync) {
        this.scheduler = scheduler;
        this.isAsync = isAsync;
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        Type responseType;
        boolean isMono;
        Class rawType = ReactorCallAdapterFactory.getRawType((Type)returnType);
        boolean bl = isMono = rawType == Mono.class;
        if (rawType != Flux.class && !isMono) {
            return null;
        }
        boolean isResult = false;
        boolean isBody = false;
        if (!(returnType instanceof ParameterizedType)) {
            String name = isMono ? "Mono" : "Flux";
            throw new IllegalStateException(name + " return type must be parameterized as " + name + "<Foo> or " + name + "<? extends Foo>");
        }
        Type observableType = ReactorCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        Class rawObservableType = ReactorCallAdapterFactory.getRawType((Type)observableType);
        if (rawObservableType == Response.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
            }
            responseType = ReactorCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)observableType));
        } else if (rawObservableType == Result.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Result must be parameterized as Result<Foo> or Result<? extends Foo>");
            }
            responseType = ReactorCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)observableType));
            isResult = true;
        } else {
            responseType = observableType;
            isBody = true;
        }
        return new ReactorCallAdapter(responseType, this.scheduler, this.isAsync, isResult, isBody, isMono);
    }
}

