/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.retrofit2.adapter.reactor;

import com.jakewharton.retrofit2.adapter.reactor.Result;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;
import retrofit2.Response;

final class ResultFlux<T>
extends Flux<Result<T>> {
    private final Publisher<Response<T>> upstream;

    ResultFlux(Publisher<Response<T>> upstream) {
        this.upstream = upstream;
    }

    public void subscribe(CoreSubscriber<? super Result<T>> subscriber) {
        this.upstream.subscribe(new ResultSubscriber(subscriber));
    }

    private static class ResultSubscriber<R>
    implements Subscriber<Response<R>> {
        private final Subscriber<? super Result<R>> subscriber;

        ResultSubscriber(Subscriber<? super Result<R>> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        public void onNext(Response<R> response) {
            this.subscriber.onNext(Result.response(response));
        }

        public void onError(Throwable throwable) {
            try {
                this.subscriber.onNext(Result.error(throwable));
            }
            catch (Throwable t) {
                try {
                    this.subscriber.onError(t);
                }
                catch (Throwable inner) {
                    Operators.onErrorDropped((Throwable)inner, (Context)Context.empty());
                }
                return;
            }
            this.subscriber.onComplete();
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

