/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.retrofit2.adapter.rxjava2;

import retrofit2.Response;

public final class Result<T> {
    private final Response<T> response;
    private final Throwable error;

    public static <T> Result<T> error(Throwable error) {
        if (error == null) {
            throw new NullPointerException("error == null");
        }
        return new Result<T>(null, error);
    }

    public static <T> Result<T> response(Response<T> response) {
        if (response == null) {
            throw new NullPointerException("response == null");
        }
        return new Result<T>(response, null);
    }

    private Result(Response<T> response, Throwable error) {
        this.response = response;
        this.error = error;
    }

    public Response<T> response() {
        return this.response;
    }

    public Throwable error() {
        return this.error;
    }

    public boolean isError() {
        return this.error != null;
    }
}

