/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rx.transformer;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Action1;

public final class ReplayingShare<T>
implements Observable.Transformer<T, T> {
    private static final ReplayingShare<Object> INSTANCE = new ReplayingShare();

    public static <T> ReplayingShare<T> instance() {
        return INSTANCE;
    }

    private ReplayingShare() {
    }

    public Observable<T> call(Observable<T> upstream) {
        LastSeen lastSeen = new LastSeen();
        return upstream.doOnNext(lastSeen.consumer).share().startWith(lastSeen.producer);
    }

    private static final class LastSeen<T> {
        private static final Object NONE = new Object();
        volatile T last = NONE;
        final Action1<T> consumer = new Action1<T>(){

            public void call(T latest) {
                LastSeen.this.last = latest;
            }
        };
        final Observable<T> producer = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                Object value = LastSeen.this.last;
                if (value != NONE) {
                    try {
                        subscriber.onNext(value);
                    }
                    catch (Throwable t) {
                        Exceptions.throwIfFatal((Throwable)t);
                        subscriber.onError(t);
                        return;
                    }
                }
                subscriber.onCompleted();
            }
        });

        LastSeen() {
        }
    }
}

