/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rx.transformer;

import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;

public final class ReplayingShare<T>
implements Observable.Transformer<T, T> {
    private static final ReplayingShare<Object> INSTANCE = new ReplayingShare();

    public static <T> ReplayingShare<T> instance() {
        return INSTANCE;
    }

    private ReplayingShare() {
    }

    public Observable<T> call(Observable<T> upstream) {
        LastSeen lastSeen = new LastSeen();
        return upstream.doOnNext(lastSeen).share().startWith(Observable.defer(lastSeen));
    }

    private static final class LastSeen<T>
    implements Action1<T>,
    Func0<Observable<T>> {
        private static final Object NONE = new Object();
        private volatile T last = NONE;

        LastSeen() {
        }

        public void call(T latest) {
            this.last = latest;
        }

        public Observable<T> call() {
            T value = this.last;
            return value != NONE ? Observable.just(value) : Observable.empty();
        }
    }
}

