/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rx;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ReplayingShare<T>
implements ObservableTransformer<T, T>,
FlowableTransformer<T, T> {
    private static final ReplayingShare<Object> INSTANCE = new ReplayingShare();

    public static <T> ReplayingShare<T> instance() {
        return INSTANCE;
    }

    private ReplayingShare() {
    }

    public Observable<T> apply(Observable<T> upstream) {
        LastSeen lastSeen = new LastSeen();
        return new LastSeenObservable(upstream.doOnNext(lastSeen).share(), lastSeen);
    }

    public Flowable<T> apply(Flowable<T> upstream) {
        LastSeen lastSeen = new LastSeen();
        return new LastSeenFlowable(upstream.doOnNext(lastSeen).share(), lastSeen);
    }

    static final class LastSeenSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<? super T> downstream;
        private final LastSeen<T> lastSeen;
        private Subscription subscription;
        private boolean first = true;

        LastSeenSubscriber(Subscriber<? super T> downstream, LastSeen<T> lastSeen) {
            this.downstream = downstream;
            this.lastSeen = lastSeen;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            this.downstream.onSubscribe((Subscription)this);
        }

        public void request(long amount) {
            if (amount == 0L) {
                return;
            }
            if (this.first) {
                this.first = false;
                Object value = this.lastSeen.value;
                if (value != null) {
                    this.downstream.onNext(value);
                    if (amount != Long.MAX_VALUE && --amount == 0L) {
                        return;
                    }
                }
            }
            this.subscription.request(amount);
        }

        public void cancel() {
            this.subscription.cancel();
        }

        public void onNext(T value) {
            this.downstream.onNext(value);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }
    }

    static final class LastSeenFlowable<T>
    extends Flowable<T> {
        private final Flowable<T> upstream;
        private final LastSeen<T> lastSeen;

        LastSeenFlowable(Flowable<T> upstream, LastSeen<T> lastSeen) {
            this.upstream = upstream;
            this.lastSeen = lastSeen;
        }

        protected void subscribeActual(Subscriber<? super T> subscriber) {
            this.upstream.subscribe(new LastSeenSubscriber<T>(subscriber, this.lastSeen));
        }
    }

    static final class LastSeenObserver<T>
    implements Observer<T> {
        private final Observer<? super T> downstream;
        private final LastSeen<T> lastSeen;

        LastSeenObserver(Observer<? super T> downstream, LastSeen<T> lastSeen) {
            this.downstream = downstream;
            this.lastSeen = lastSeen;
        }

        public void onSubscribe(Disposable d) {
            this.downstream.onSubscribe(d);
            Object value = this.lastSeen.value;
            if (value != null) {
                this.downstream.onNext(value);
            }
        }

        public void onNext(T value) {
            this.downstream.onNext(value);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        public void onError(Throwable e) {
            this.downstream.onError(e);
        }
    }

    static final class LastSeenObservable<T>
    extends Observable<T> {
        private final Observable<T> upstream;
        private final LastSeen<T> lastSeen;

        LastSeenObservable(Observable<T> upstream, LastSeen<T> lastSeen) {
            this.upstream = upstream;
            this.lastSeen = lastSeen;
        }

        protected void subscribeActual(Observer<? super T> observer) {
            this.upstream.subscribe(new LastSeenObserver<T>(observer, this.lastSeen));
        }
    }

    static final class LastSeen<T>
    implements Consumer<T> {
        volatile T value;

        LastSeen() {
        }

        public void accept(T latest) {
            this.value = latest;
        }
    }
}

