/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rx3;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ReplayingShare<T>
implements ObservableTransformer<T, T>,
FlowableTransformer<T, T> {
    private static final ReplayingShare<Object> INSTANCE = new ReplayingShare<Object>(null);
    @Nullable
    private final T defaultValue;

    @NonNull
    public static <T> ReplayingShare<T> instance() {
        return INSTANCE;
    }

    @NonNull
    public static <T> ReplayingShare<T> createWithDefault(@NonNull T defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue == null");
        }
        return new ReplayingShare<T>(defaultValue);
    }

    private ReplayingShare(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Observable<T> apply(Observable<T> upstream) {
        LastSeen<T> lastSeen = new LastSeen<T>(this.defaultValue);
        return new LastSeenObservable<T>(upstream.doOnEach(lastSeen).share(), lastSeen);
    }

    public Flowable<T> apply(Flowable<T> upstream) {
        LastSeen<T> lastSeen = new LastSeen<T>(this.defaultValue);
        return new LastSeenFlowable<T>(upstream.doOnEach(lastSeen).share(), lastSeen);
    }

    static final class LastSeenSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<? super T> downstream;
        private final LastSeen<T> lastSeen;
        @Nullable
        private Subscription subscription;
        private volatile boolean cancelled;
        private boolean first = true;

        LastSeenSubscriber(Subscriber<? super T> downstream, LastSeen<T> lastSeen) {
            this.downstream = downstream;
            this.lastSeen = lastSeen;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            this.downstream.onSubscribe((Subscription)this);
        }

        public void request(long amount) {
            if (amount == 0L) {
                return;
            }
            if (this.first) {
                this.first = false;
                Object value = this.lastSeen.value;
                if (value != null && !this.cancelled) {
                    this.downstream.onNext(value);
                    if (amount != Long.MAX_VALUE && --amount == 0L) {
                        return;
                    }
                }
            }
            Subscription subscription = this.subscription;
            assert (subscription != null);
            subscription.request(amount);
        }

        public void cancel() {
            Subscription subscription = this.subscription;
            assert (subscription != null);
            this.cancelled = true;
            subscription.cancel();
        }

        public void onNext(T value) {
            this.downstream.onNext(value);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }
    }

    static final class LastSeenFlowable<T>
    extends Flowable<T> {
        private final Flowable<T> upstream;
        private final LastSeen<T> lastSeen;

        LastSeenFlowable(Flowable<T> upstream, LastSeen<T> lastSeen) {
            this.upstream = upstream;
            this.lastSeen = lastSeen;
        }

        protected void subscribeActual(Subscriber<? super T> subscriber) {
            this.upstream.subscribe(new LastSeenSubscriber<T>(subscriber, this.lastSeen));
        }
    }

    static final class LastSeenObserver<T>
    implements Observer<T> {
        private final Observer<? super T> downstream;
        private final LastSeen<T> lastSeen;

        LastSeenObserver(Observer<? super T> downstream, LastSeen<T> lastSeen) {
            this.downstream = downstream;
            this.lastSeen = lastSeen;
        }

        public void onSubscribe(Disposable d) {
            this.downstream.onSubscribe(d);
            Object value = this.lastSeen.value;
            if (value != null && !d.isDisposed()) {
                this.downstream.onNext(value);
            }
        }

        public void onNext(T value) {
            this.downstream.onNext(value);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        public void onError(Throwable e) {
            this.downstream.onError(e);
        }
    }

    static final class LastSeenObservable<T>
    extends Observable<T> {
        private final Observable<T> upstream;
        private final LastSeen<T> lastSeen;

        LastSeenObservable(Observable<T> upstream, LastSeen<T> lastSeen) {
            this.upstream = upstream;
            this.lastSeen = lastSeen;
        }

        protected void subscribeActual(Observer<? super T> observer) {
            this.upstream.subscribe(new LastSeenObserver<T>(observer, this.lastSeen));
        }
    }

    static final class LastSeen<T>
    implements Observer<T>,
    Subscriber<T> {
        @Nullable
        private final T defaultValue;
        @Nullable
        volatile T value;

        LastSeen(@Nullable T defaultValue) {
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }

        public void onNext(T value) {
            this.value = value;
        }

        public void onError(Throwable e) {
            this.value = this.defaultValue;
        }

        public void onComplete() {
            this.value = this.defaultValue;
        }

        public void onSubscribe(Subscription ignored) {
        }

        public void onSubscribe(Disposable ignored) {
        }
    }
}

