/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v7.widget;

import android.support.v7.widget.PopupMenu;
import android.view.MenuItem;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class PopupMenuItemClickOnSubscribe
implements Observable.OnSubscribe<MenuItem> {
    final PopupMenu view;

    public PopupMenuItemClickOnSubscribe(PopupMenu view) {
        this.view = view;
    }

    public void call(final Subscriber<? super MenuItem> subscriber) {
        MainThreadSubscription.verifyMainThread();
        PopupMenu.OnMenuItemClickListener listener = new PopupMenu.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)item);
                }
                return true;
            }
        };
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                PopupMenuItemClickOnSubscribe.this.view.setOnMenuItemClickListener(null);
            }
        });
        this.view.setOnMenuItemClickListener(listener);
    }
}

