/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v7.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.v7.widget.SearchView;
import com.jakewharton.rxbinding.internal.Preconditions;
import com.jakewharton.rxbinding.support.v7.widget.SearchViewQueryTextChangeEventsOnSubscribe;
import com.jakewharton.rxbinding.support.v7.widget.SearchViewQueryTextChangesOnSubscribe;
import com.jakewharton.rxbinding.support.v7.widget.SearchViewQueryTextEvent;
import rx.Observable;
import rx.functions.Action1;

public final class RxSearchView {
    @CheckResult
    @NonNull
    public static Observable<SearchViewQueryTextEvent> queryTextChangeEvents(@NonNull SearchView view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new SearchViewQueryTextChangeEventsOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Observable<CharSequence> queryTextChanges(@NonNull SearchView view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new SearchViewQueryTextChangesOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Action1<? super CharSequence> query(final @NonNull SearchView view, final boolean submit) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<CharSequence>(){

            public void call(CharSequence text) {
                view.setQuery(text, submit);
            }
        };
    }

    private RxSearchView() {
        throw new AssertionError((Object)"No instances.");
    }
}

