/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v7.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import com.jakewharton.rxbinding.internal.Preconditions;
import com.jakewharton.rxbinding.support.v7.widget.ToolbarItemClickOnSubscribe;
import com.jakewharton.rxbinding.support.v7.widget.ToolbarNavigationClickOnSubscribe;
import rx.Observable;
import rx.functions.Action1;

public final class RxToolbar {
    @CheckResult
    @NonNull
    public static Observable<MenuItem> itemClicks(@NonNull Toolbar view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new ToolbarItemClickOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Observable<Void> navigationClicks(@NonNull Toolbar view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new ToolbarNavigationClickOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Action1<? super CharSequence> title(final @NonNull Toolbar view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<CharSequence>(){

            public void call(CharSequence title) {
                view.setTitle(title);
            }
        };
    }

    @CheckResult
    @NonNull
    public static Action1<? super Integer> titleRes(final @NonNull Toolbar view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Integer>(){

            public void call(Integer titleRes) {
                view.setTitle(titleRes.intValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Action1<? super CharSequence> subtitle(final @NonNull Toolbar view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<CharSequence>(){

            public void call(CharSequence subtitle) {
                view.setSubtitle(subtitle);
            }
        };
    }

    @CheckResult
    @NonNull
    public static Action1<? super Integer> subtitleRes(final @NonNull Toolbar view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Integer>(){

            public void call(Integer subtitleRes) {
                view.setSubtitle(subtitleRes.intValue());
            }
        };
    }

    private RxToolbar() {
        throw new AssertionError((Object)"No instances.");
    }
}

