/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v7.widget;

import android.support.v7.widget.SearchView;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class SearchViewQueryTextChangesOnSubscribe
implements Observable.OnSubscribe<CharSequence> {
    final SearchView view;

    SearchViewQueryTextChangesOnSubscribe(SearchView view) {
        this.view = view;
    }

    public void call(final Subscriber<? super CharSequence> subscriber) {
        MainThreadSubscription.verifyMainThread();
        SearchView.OnQueryTextListener watcher = new SearchView.OnQueryTextListener(){

            public boolean onQueryTextChange(String s) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)s);
                    return true;
                }
                return false;
            }

            public boolean onQueryTextSubmit(String query) {
                return false;
            }
        };
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                SearchViewQueryTextChangesOnSubscribe.this.view.setOnQueryTextListener(null);
            }
        });
        this.view.setOnQueryTextListener(watcher);
        subscriber.onNext((Object)this.view.getQuery());
    }
}

