/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v7.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.v7.widget.SearchView;
import android.view.View;
import com.jakewharton.rxbinding.view.ViewEvent;

public final class SearchViewQueryTextEvent
extends ViewEvent<SearchView> {
    private final CharSequence queryText;
    private final boolean submitted;

    @CheckResult
    @NonNull
    public static SearchViewQueryTextEvent create(@NonNull SearchView view, @NonNull CharSequence queryText, boolean submitted) {
        return new SearchViewQueryTextEvent(view, queryText, submitted);
    }

    private SearchViewQueryTextEvent(@NonNull SearchView view, @NonNull CharSequence queryText, boolean submitted) {
        super((View)view);
        this.queryText = queryText;
        this.submitted = submitted;
    }

    @NonNull
    public CharSequence queryText() {
        return this.queryText;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchViewQueryTextEvent)) {
            return false;
        }
        SearchViewQueryTextEvent other = (SearchViewQueryTextEvent)((Object)o);
        return other.view() == this.view() && other.queryText.equals(this.queryText) && other.submitted == this.submitted;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + ((SearchView)this.view()).hashCode();
        result = result * 37 + this.queryText.hashCode();
        result = result * 37 + (this.submitted ? 1 : 0);
        return result;
    }

    public String toString() {
        return "SearchViewQueryTextEvent{view=" + this.view() + ", queryText=" + this.queryText + ", submitted=" + this.submitted + '}';
    }
}

