/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v4.widget;

import android.support.v4.widget.DrawerLayout;
import android.view.View;
import com.jakewharton.rxbinding.internal.MainThreadSubscription;
import com.jakewharton.rxbinding.internal.Preconditions;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

final class DrawerLayoutDrawerOpenedOnSubscribe
implements Observable.OnSubscribe<Boolean> {
    private final DrawerLayout view;
    private final int gravity;

    DrawerLayoutDrawerOpenedOnSubscribe(DrawerLayout view, int gravity) {
        this.view = view;
        this.gravity = gravity;
    }

    public void call(final Subscriber<? super Boolean> subscriber) {
        Preconditions.checkUiThread();
        DrawerLayout.SimpleDrawerListener listener = new DrawerLayout.SimpleDrawerListener(){

            public void onDrawerOpened(View drawerView) {
                int drawerGravity;
                if (!subscriber.isUnsubscribed() && (drawerGravity = ((DrawerLayout.LayoutParams)drawerView.getLayoutParams()).gravity) == DrawerLayoutDrawerOpenedOnSubscribe.this.gravity) {
                    subscriber.onNext((Object)true);
                }
            }

            public void onDrawerSlide(View drawerView, float slideOffset) {
            }

            public void onDrawerStateChanged(int newState) {
            }

            public void onDrawerClosed(View drawerView) {
                int drawerGravity;
                if (!subscriber.isUnsubscribed() && (drawerGravity = ((DrawerLayout.LayoutParams)drawerView.getLayoutParams()).gravity) == DrawerLayoutDrawerOpenedOnSubscribe.this.gravity) {
                    subscriber.onNext((Object)false);
                }
            }
        };
        this.view.setDrawerListener((DrawerLayout.DrawerListener)listener);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                DrawerLayoutDrawerOpenedOnSubscribe.this.view.setDrawerListener(null);
            }
        });
        subscriber.onNext((Object)this.view.isDrawerOpen(this.gravity));
    }
}

