/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v4.view;

import android.support.v4.view.MenuItemCompat;
import android.view.MenuItem;
import com.jakewharton.rxbinding.internal.Preconditions;
import com.jakewharton.rxbinding.view.MenuItemActionViewEvent;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;
import rx.functions.Func1;

final class MenuItemActionViewEventOnSubscribe
implements Observable.OnSubscribe<MenuItemActionViewEvent> {
    final MenuItem menuItem;
    final Func1<? super MenuItemActionViewEvent, Boolean> handled;

    MenuItemActionViewEventOnSubscribe(MenuItem menuItem, Func1<? super MenuItemActionViewEvent, Boolean> handled) {
        this.menuItem = menuItem;
        this.handled = handled;
    }

    public void call(final Subscriber<? super MenuItemActionViewEvent> subscriber) {
        Preconditions.checkUiThread();
        MenuItemCompat.OnActionExpandListener listener = new MenuItemCompat.OnActionExpandListener(){

            public boolean onMenuItemActionExpand(MenuItem item) {
                MenuItemActionViewEvent event = MenuItemActionViewEvent.create((MenuItem)MenuItemActionViewEventOnSubscribe.this.menuItem, (MenuItemActionViewEvent.Kind)MenuItemActionViewEvent.Kind.EXPAND);
                return this.onEvent(event);
            }

            public boolean onMenuItemActionCollapse(MenuItem item) {
                MenuItemActionViewEvent event = MenuItemActionViewEvent.create((MenuItem)MenuItemActionViewEventOnSubscribe.this.menuItem, (MenuItemActionViewEvent.Kind)MenuItemActionViewEvent.Kind.COLLAPSE);
                return this.onEvent(event);
            }

            private boolean onEvent(MenuItemActionViewEvent event) {
                if (((Boolean)MenuItemActionViewEventOnSubscribe.this.handled.call((Object)event)).booleanValue()) {
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onNext((Object)event);
                    }
                    return true;
                }
                return false;
            }
        };
        MenuItemCompat.setOnActionExpandListener((MenuItem)this.menuItem, (MenuItemCompat.OnActionExpandListener)listener);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                MenuItemCompat.setOnActionExpandListener((MenuItem)MenuItemActionViewEventOnSubscribe.this.menuItem, null);
            }
        });
    }
}

