/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v4.view;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import com.jakewharton.rxbinding.internal.Preconditions;
import com.jakewharton.rxbinding.support.v4.view.ViewPagerPageScrollStateChangedOnSubscribe;
import com.jakewharton.rxbinding.support.v4.view.ViewPagerPageSelectedOnSubscribe;
import rx.Observable;
import rx.functions.Action1;

public final class RxViewPager {
    @CheckResult
    @NonNull
    public static Observable<Integer> pageScrollStateChanges(@NonNull ViewPager view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new ViewPagerPageScrollStateChangedOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Observable<Integer> pageSelections(@NonNull ViewPager view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new ViewPagerPageSelectedOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Action1<? super Integer> currentItem(final @NonNull ViewPager view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Integer>(){

            public void call(Integer value) {
                view.setCurrentItem(value.intValue());
            }
        };
    }

    private RxViewPager() {
        throw new AssertionError((Object)"No instances.");
    }
}

