/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v4.widget;

import android.support.v4.widget.DrawerLayout;
import android.view.View;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class DrawerLayoutDrawerOpenedOnSubscribe
implements Observable.OnSubscribe<Boolean> {
    final DrawerLayout view;
    final int gravity;

    DrawerLayoutDrawerOpenedOnSubscribe(DrawerLayout view, int gravity) {
        this.view = view;
        this.gravity = gravity;
    }

    public void call(final Subscriber<? super Boolean> subscriber) {
        MainThreadSubscription.verifyMainThread();
        DrawerLayout.SimpleDrawerListener listener = new DrawerLayout.SimpleDrawerListener(){

            public void onDrawerOpened(View drawerView) {
                int drawerGravity;
                if (!subscriber.isUnsubscribed() && (drawerGravity = ((DrawerLayout.LayoutParams)drawerView.getLayoutParams()).gravity) == DrawerLayoutDrawerOpenedOnSubscribe.this.gravity) {
                    subscriber.onNext((Object)true);
                }
            }

            public void onDrawerSlide(View drawerView, float slideOffset) {
            }

            public void onDrawerStateChanged(int newState) {
            }

            public void onDrawerClosed(View drawerView) {
                int drawerGravity;
                if (!subscriber.isUnsubscribed() && (drawerGravity = ((DrawerLayout.LayoutParams)drawerView.getLayoutParams()).gravity) == DrawerLayoutDrawerOpenedOnSubscribe.this.gravity) {
                    subscriber.onNext((Object)false);
                }
            }
        };
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                DrawerLayoutDrawerOpenedOnSubscribe.this.view.setDrawerListener(null);
            }
        });
        this.view.setDrawerListener((DrawerLayout.DrawerListener)listener);
        subscriber.onNext((Object)this.view.isDrawerOpen(this.gravity));
    }
}

