/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v4.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.v4.widget.SlidingPaneLayout;
import com.jakewharton.rxbinding.internal.Preconditions;
import com.jakewharton.rxbinding.support.v4.widget.SlidingPaneLayoutPaneOpenedOnSubscribe;
import com.jakewharton.rxbinding.support.v4.widget.SlidingPaneLayoutSlideOnSubscribe;
import rx.Observable;
import rx.functions.Action1;

public final class RxSlidingPaneLayout {
    @CheckResult
    @NonNull
    public static Observable<Boolean> panelOpens(@NonNull SlidingPaneLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new SlidingPaneLayoutPaneOpenedOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Observable<Float> panelSlides(@NonNull SlidingPaneLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return Observable.create((Observable.OnSubscribe)new SlidingPaneLayoutSlideOnSubscribe(view));
    }

    @CheckResult
    @NonNull
    public static Action1<? super Boolean> open(final @NonNull SlidingPaneLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Action1<Boolean>(){

            public void call(Boolean value) {
                if (value.booleanValue()) {
                    view.openPane();
                } else {
                    view.closePane();
                }
            }
        };
    }

    private RxSlidingPaneLayout() {
        throw new AssertionError((Object)"No instances.");
    }
}

