/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.PopupMenu;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class PopupMenuDismissObservable
extends Observable<Object> {
    private final PopupMenu view;

    PopupMenuDismissObservable(PopupMenu view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnDismissListener((PopupMenu.OnDismissListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements PopupMenu.OnDismissListener {
        private final PopupMenu popupMenu;
        private final Observer<? super Object> observer;

        Listener(PopupMenu popupMenu, Observer<? super Object> observer) {
            this.popupMenu = popupMenu;
            this.observer = observer;
        }

        public void onDismiss(PopupMenu menu) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)Notification.INSTANCE);
            }
        }

        protected void onDispose() {
            this.popupMenu.setOnDismissListener(null);
        }
    }
}

