/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v4.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.v4.widget.SlidingPaneLayout;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.support.v4.widget.SlidingPaneLayoutPaneOpenedObservable;
import com.jakewharton.rxbinding2.support.v4.widget.SlidingPaneLayoutSlideObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

public final class RxSlidingPaneLayout {
    @CheckResult
    @NonNull
    public static InitialValueObservable<Boolean> panelOpens(@NonNull SlidingPaneLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new SlidingPaneLayoutPaneOpenedObservable(view);
    }

    @CheckResult
    @NonNull
    public static Observable<Float> panelSlides(@NonNull SlidingPaneLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new SlidingPaneLayoutSlideObservable(view);
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Boolean> open(final @NonNull SlidingPaneLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Consumer<Boolean>(){

            public void accept(Boolean value) {
                if (value.booleanValue()) {
                    view.openPane();
                } else {
                    view.closePane();
                }
            }
        };
    }

    private RxSlidingPaneLayout() {
        throw new AssertionError((Object)"No instances.");
    }
}

