/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v4.view;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.support.v4.view.ViewPagerPageScrollStateChangedObservable;
import com.jakewharton.rxbinding2.support.v4.view.ViewPagerPageSelectedObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

public final class RxViewPager {
    @CheckResult
    @NonNull
    public static Observable<Integer> pageScrollStateChanges(@NonNull ViewPager view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new ViewPagerPageScrollStateChangedObservable(view);
    }

    @CheckResult
    @NonNull
    public static InitialValueObservable<Integer> pageSelections(@NonNull ViewPager view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new ViewPagerPageSelectedObservable(view);
    }

    @Deprecated
    @CheckResult
    @NonNull
    public static Consumer<? super Integer> currentItem(final @NonNull ViewPager view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Consumer<Integer>(){

            public void accept(Integer value) {
                view.setCurrentItem(value.intValue());
            }
        };
    }

    private RxViewPager() {
        throw new AssertionError((Object)"No instances.");
    }
}

