/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v4.view;

import android.support.v4.view.ViewPager;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ViewPagerPageScrollStateChangedObservable
extends Observable<Integer> {
    private final ViewPager view;

    ViewPagerPageScrollStateChangedObservable(ViewPager view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnPageChangeListener((ViewPager.OnPageChangeListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements ViewPager.OnPageChangeListener {
        private final ViewPager view;
        private final Observer<? super Integer> observer;

        Listener(ViewPager view, Observer<? super Integer> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)state);
            }
        }

        protected void onDispose() {
            this.view.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
    }
}

