/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v4.widget;

import android.support.v4.widget.SlidingPaneLayout;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SlidingPaneLayoutSlideObservable
extends Observable<Float> {
    private final SlidingPaneLayout view;

    SlidingPaneLayoutSlideObservable(SlidingPaneLayout view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Float> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setPanelSlideListener((SlidingPaneLayout.PanelSlideListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements SlidingPaneLayout.PanelSlideListener {
        private final SlidingPaneLayout view;
        private final Observer<? super Float> observer;

        Listener(SlidingPaneLayout view, Observer<? super Float> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onPanelSlide(View panel, float slideOffset) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)Float.valueOf(slideOffset));
            }
        }

        public void onPanelOpened(View panel) {
        }

        public void onPanelClosed(View panel) {
        }

        protected void onDispose() {
            this.view.setPanelSlideListener(null);
        }
    }
}

