/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.View;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ViewAttachesObservable
extends Observable<Object> {
    private final boolean callOnAttach;
    private final View view;

    ViewAttachesObservable(View view, boolean callOnAttach) {
        this.view = view;
        this.callOnAttach = callOnAttach;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, this.callOnAttach, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnAttachStateChangeListener {
        private final View view;
        private final boolean callOnAttach;
        private final Observer<? super Object> observer;

        Listener(View view, boolean callOnAttach, Observer<? super Object> observer) {
            this.view = view;
            this.callOnAttach = callOnAttach;
            this.observer = observer;
        }

        public void onViewAttachedToWindow(View v) {
            if (this.callOnAttach && !this.isDisposed()) {
                this.observer.onNext((Object)Notification.INSTANCE);
            }
        }

        public void onViewDetachedFromWindow(View v) {
            if (!this.callOnAttach && !this.isDisposed()) {
                this.observer.onNext((Object)Notification.INSTANCE);
            }
        }

        protected void onDispose() {
            this.view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }
}

