/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.widget.CompoundButton;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class CompoundButtonCheckedChangeObservable
extends InitialValueObservable<Boolean> {
    private final CompoundButton view;

    CompoundButtonCheckedChangeObservable(CompoundButton view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super Boolean> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)listener);
    }

    @Override
    protected Boolean getInitialValue() {
        return this.view.isChecked();
    }

    static final class Listener
    extends MainThreadDisposable
    implements CompoundButton.OnCheckedChangeListener {
        private final CompoundButton view;
        private final Observer<? super Boolean> observer;

        Listener(CompoundButton view, Observer<? super Boolean> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)isChecked);
            }
        }

        protected void onDispose() {
            this.view.setOnCheckedChangeListener(null);
        }
    }
}

