/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.widget.SearchView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.SearchViewQueryTextEvent;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SearchViewQueryTextChangeEventsObservable
extends InitialValueObservable<SearchViewQueryTextEvent> {
    private final SearchView view;

    SearchViewQueryTextChangeEventsObservable(SearchView view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super SearchViewQueryTextEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnQueryTextListener((SearchView.OnQueryTextListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected SearchViewQueryTextEvent getInitialValue() {
        return SearchViewQueryTextEvent.create(this.view, this.view.getQuery(), false);
    }

    static final class Listener
    extends MainThreadDisposable
    implements SearchView.OnQueryTextListener {
        private final SearchView view;
        private final Observer<? super SearchViewQueryTextEvent> observer;

        Listener(SearchView view, Observer<? super SearchViewQueryTextEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public boolean onQueryTextChange(String s) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)SearchViewQueryTextEvent.create(this.view, s, false));
                return true;
            }
            return false;
        }

        public boolean onQueryTextSubmit(String query) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)SearchViewQueryTextEvent.create(this.view, query, true));
                return true;
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnQueryTextListener(null);
        }
    }
}

