/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.widget.SearchView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SearchViewQueryTextChangesObservable
extends InitialValueObservable<CharSequence> {
    private final SearchView view;

    SearchViewQueryTextChangesObservable(SearchView view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super CharSequence> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnQueryTextListener((SearchView.OnQueryTextListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected CharSequence getInitialValue() {
        return this.view.getQuery();
    }

    static final class Listener
    extends MainThreadDisposable
    implements SearchView.OnQueryTextListener {
        private final SearchView view;
        private final Observer<? super CharSequence> observer;

        public Listener(SearchView view, Observer<? super CharSequence> observer) {
            this.view = view;
            this.observer = observer;
        }

        public boolean onQueryTextChange(String s) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)s);
                return true;
            }
            return false;
        }

        public boolean onQueryTextSubmit(String query) {
            return false;
        }

        protected void onDispose() {
            this.view.setOnQueryTextListener(null);
        }
    }
}

