/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.view.KeyEvent;
import android.widget.TextView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.TextViewEditorActionEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;

final class TextViewEditorActionEventObservable
extends Observable<TextViewEditorActionEvent> {
    private final TextView view;
    private final Predicate<? super TextViewEditorActionEvent> handled;

    TextViewEditorActionEventObservable(TextView view, Predicate<? super TextViewEditorActionEvent> handled) {
        this.view = view;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super TextViewEditorActionEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer, this.handled);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnEditorActionListener((TextView.OnEditorActionListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements TextView.OnEditorActionListener {
        private final TextView view;
        private final Observer<? super TextViewEditorActionEvent> observer;
        private final Predicate<? super TextViewEditorActionEvent> handled;

        Listener(TextView view, Observer<? super TextViewEditorActionEvent> observer, Predicate<? super TextViewEditorActionEvent> handled) {
            this.view = view;
            this.observer = observer;
            this.handled = handled;
        }

        public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
            TextViewEditorActionEvent event = TextViewEditorActionEvent.create(this.view, actionId, keyEvent);
            try {
                if (!this.isDisposed() && this.handled.test((Object)event)) {
                    this.observer.onNext((Object)event);
                    return true;
                }
            }
            catch (Exception e) {
                this.observer.onError((Throwable)e);
                this.dispose();
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnEditorActionListener(null);
        }
    }
}

