/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.MotionEvent;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;

final class ViewTouchObservable
extends Observable<MotionEvent> {
    private final View view;
    private final Predicate<? super MotionEvent> handled;

    ViewTouchObservable(View view, Predicate<? super MotionEvent> handled) {
        this.view = view;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super MotionEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, this.handled, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnTouchListener((View.OnTouchListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnTouchListener {
        private final View view;
        private final Predicate<? super MotionEvent> handled;
        private final Observer<? super MotionEvent> observer;

        Listener(View view, Predicate<? super MotionEvent> handled, Observer<? super MotionEvent> observer) {
            this.view = view;
            this.handled = handled;
            this.observer = observer;
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (!this.isDisposed()) {
                try {
                    if (this.handled.test((Object)event)) {
                        this.observer.onNext((Object)event);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnTouchListener(null);
        }
    }
}

