/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.view.View;
import android.widget.AdapterView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class AdapterViewItemSelectionObservable
extends InitialValueObservable<Integer> {
    private final AdapterView<?> view;

    AdapterViewItemSelectionObservable(AdapterView<?> view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected Integer getInitialValue() {
        return this.view.getSelectedItemPosition();
    }

    static final class Listener
    extends MainThreadDisposable
    implements AdapterView.OnItemSelectedListener {
        private final AdapterView<?> view;
        private final Observer<? super Integer> observer;

        Listener(AdapterView<?> view, Observer<? super Integer> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)position);
            }
        }

        public void onNothingSelected(AdapterView<?> adapterView) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)-1);
            }
        }

        protected void onDispose() {
            this.view.setOnItemSelectedListener(null);
        }
    }
}

