/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.TextView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.widget.TextViewAfterTextChangeEvent;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class TextViewAfterTextChangeEventObservable
extends InitialValueObservable<TextViewAfterTextChangeEvent> {
    private final TextView view;

    TextViewAfterTextChangeEventObservable(TextView view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super TextViewAfterTextChangeEvent> observer) {
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addTextChangedListener((TextWatcher)listener);
    }

    @Override
    protected TextViewAfterTextChangeEvent getInitialValue() {
        return TextViewAfterTextChangeEvent.create(this.view, this.view.getEditableText());
    }

    static final class Listener
    extends MainThreadDisposable
    implements TextWatcher {
        private final TextView view;
        private final Observer<? super TextViewAfterTextChangeEvent> observer;

        Listener(TextView view, Observer<? super TextViewAfterTextChangeEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            this.observer.onNext((Object)TextViewAfterTextChangeEvent.create(this.view, s));
        }

        protected void onDispose() {
            this.view.removeTextChangedListener((TextWatcher)this);
        }
    }
}

