/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding3.viewpager;

import androidx.viewpager.widget.ViewPager;
import com.jakewharton.rxbinding3.internal.Preconditions;
import com.jakewharton.rxbinding3.viewpager.ViewPagerPageScrollEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jakewharton/rxbinding3/viewpager/ViewPagerPageScrolledObservable;", "Lio/reactivex/Observable;", "Lcom/jakewharton/rxbinding3/viewpager/ViewPagerPageScrollEvent;", "view", "Landroidx/viewpager/widget/ViewPager;", "(Landroidx/viewpager/widget/ViewPager;)V", "subscribeActual", "", "observer", "Lio/reactivex/Observer;", "Listener", "rxbinding-viewpager_release"})
final class ViewPagerPageScrolledObservable
extends Observable<ViewPagerPageScrollEvent> {
    private final ViewPager view;

    protected void subscribeActual(@NotNull Observer<? super ViewPagerPageScrollEvent> observer) {
        Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnPageChangeListener((ViewPager.OnPageChangeListener)listener);
    }

    public ViewPagerPageScrolledObservable(@NotNull ViewPager view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.view = view;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jakewharton/rxbinding3/viewpager/ViewPagerPageScrolledObservable$Listener;", "Lio/reactivex/android/MainThreadDisposable;", "Landroidx/viewpager/widget/ViewPager$OnPageChangeListener;", "view", "Landroidx/viewpager/widget/ViewPager;", "observer", "Lio/reactivex/Observer;", "Lcom/jakewharton/rxbinding3/viewpager/ViewPagerPageScrollEvent;", "(Landroidx/viewpager/widget/ViewPager;Lio/reactivex/Observer;)V", "onDispose", "", "onPageScrollStateChanged", "state", "", "onPageScrolled", "position", "positionOffset", "", "positionOffsetPixels", "onPageSelected", "rxbinding-viewpager_release"})
    private static final class Listener
    extends MainThreadDisposable
    implements ViewPager.OnPageChangeListener {
        private final ViewPager view;
        private final Observer<? super ViewPagerPageScrollEvent> observer;

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (!this.isDisposed()) {
                ViewPagerPageScrollEvent event = new ViewPagerPageScrollEvent(this.view, position, positionOffset, positionOffsetPixels);
                this.observer.onNext((Object)event);
            }
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }

        protected void onDispose() {
            this.view.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }

        public Listener(@NotNull ViewPager view, @NotNull Observer<? super ViewPagerPageScrollEvent> observer) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            this.view = view;
            this.observer = observer;
        }
    }
}

