/*******************************************************************************
 * Copyright 2016 Jalian Systems Pvt. Ltd.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package net.sourceforge.marathon.javaagent.components;

import java.awt.Color;
import java.awt.Component;
import java.util.logging.Logger;

import javax.swing.JColorChooser;

import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.JavaTargetLocator.JWindow;

public class JColorChooserJavaElement extends AbstractJavaElement {

    public static final Logger LOGGER = Logger.getLogger(JColorChooserJavaElement.class.getName());

    public JColorChooserJavaElement(Component component, IJavaAgent driver, JWindow window) {
        super(component, driver, window);
    }

    @Override
    public boolean marathon_select(String value) {
        if (!value.equals("")) {
            try {
                ((JColorChooser) component).setColor(Color.decode(value));
                return true;
            } catch (Throwable t) {
                throw new NumberFormatException("Invalid value for '" + value + "' for color-chooser '");
            }
        }
        return false;
    }

}
