/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.Platform;

public class ProcessLauncher {
    public static final Logger LOGGER = Logger.getLogger(ProcessLauncher.class.getName());

    public static String launch(String ... params) throws IOException {
        LaunchConfig config = new LaunchConfig(params);
        ProcessBuilder pb = new ProcessBuilder(config.getExecArgs());
        Process process = pb.start();
        InputStream output = process.getInputStream();
        return ProcessLauncher.readAll(output);
    }

    private static String readAll(InputStream output) throws IOException {
        int n;
        BufferedReader r = new BufferedReader(new InputStreamReader(output));
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((n = ((Reader)r).read(buf, 0, 1024)) != -1) {
            sb.append(buf, 0, n);
        }
        return sb.toString().replaceAll("\r\n", "\n");
    }

    private static class LaunchConfig {
        private String[] command;
        private String shell;

        public LaunchConfig(String[] params) {
            this.command = params;
            this.shell = this.getShell();
        }

        private String getShell() {
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                return "cmd.exe";
            }
            return "/bin/sh";
        }

        public String[] getExecArgs() {
            String[] execArgs = new String[3];
            execArgs[0] = this.shell;
            execArgs[1] = this.shell.endsWith("sh") ? "-c" : "/c";
            StringBuilder command = new StringBuilder();
            boolean first = true;
            for (String cmd : this.command) {
                if (first) {
                    if ((cmd = cmd.replace('/', '\\')).contains(" ")) {
                        cmd = '\"' + cmd + '\"';
                    }
                    first = false;
                }
                command.append(cmd).append(" ");
            }
            command.setLength(command.length() - 1);
            execArgs[2] = command.toString();
            execArgs[2] = Platform.getCurrent().is(Platform.WINDOWS) ? "\"" + command + "\"" : command.toString();
            return execArgs;
        }
    }
}

