/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import net.sourceforge.marathon.javaagent.Device;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IDevice;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.InvalidElementStateException;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.JavaElementPropertyAccessor;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.StaleElementReferenceException;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.css.FindByCssSelector;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractJavaElement
extends JavaElementPropertyAccessor
implements IJavaElement {
    public static final Logger LOGGER = Logger.getLogger(AbstractJavaElement.class.getName());
    protected IJavaAgent driver;
    protected JavaTargetLocator.JWindow window;
    private UUID id;

    public AbstractJavaElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        super(component);
        this.driver = driver;
        this.window = window;
    }

    public AbstractJavaElement(AbstractJavaElement parent) {
        this(parent.component, parent.driver, parent.window);
        this.id = parent.getId();
    }

    @Override
    public void click() {
        this.verifyCanInteractWithElement();
        EventQueueWait.requestFocus(this.component);
        Point p = this.getMidpoint();
        this.click(0, 1, p.x, p.y);
    }

    @Override
    public void sendKeys(CharSequence ... keysToSend) {
        this.verifyCanInteractWithElement();
        EventQueueWait.requestFocus(this.component);
        IDevice kb = this.driver.getDevices();
        kb.sendKeys(this.component, keysToSend);
    }

    @Override
    public void clear() {
        EventQueueWait.call_noexc(this, "_clear", new Object[0]);
    }

    public void _clear() {
        this.verifyCanInteractWithElement();
        Component active = Device.getActiveComponent(this.component);
        if (active instanceof JTextComponent) {
            ((JTextComponent)active).setText("");
        } else if (active instanceof TextComponent) {
            ((TextComponent)active).setText("");
        } else {
            throw new UnsupportedCommandException("Clear not supported on " + active.getClass().getName(), null);
        }
    }

    @Override
    public String getAttribute(String name) {
        if (name.startsWith("matches-css-")) {
            return this.matchesCSS(name.substring("matches-css-".length()));
        }
        if (name.startsWith("call-")) {
            return this.callMethod(new JSONObject(name.substring("call-".length())));
        }
        return super.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String matchesCSS(String selector) {
        long implicitWait = this.getDriver().getImplicitWait();
        try {
            this.getDriver().setImplicitWait(0L);
            String string = Boolean.toString(this.findElementsByCssSelector(selector).size() == 1);
            return string;
        }
        finally {
            this.driver.setImplicitWait(implicitWait);
        }
    }

    @Override
    public String getCssValue(String propertyName) {
        throw new UnsupportedCommandException("Java driver does not support getCssValue()", null);
    }

    private void verifyCanInteractWithElement() {
        try {
            if (!this.isEnabled()) {
                throw new InvalidElementStateException("You may only interact with enabled elements", null);
            }
        }
        catch (UnsupportedCommandException unsupportedCommandException) {
            // empty catch block
        }
        this.verifyElementNotStale();
    }

    private void verifyElementNotStale() {
        String handle = this.driver.getWindowHandle();
        if (handle == null || !handle.equals(this.window.getHandle())) {
            throw new StaleElementReferenceException("Element appears to be stale. Did you navigate away from the window that contained it?  And is the current window focussed the same as the one holding this element?", null);
        }
    }

    @Override
    public final IJavaElement findElementByName(String using) {
        List<IJavaElement> elements = this.findElementsByName(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("No component found using name: " + using, null);
        }
        return elements.get(0);
    }

    @Override
    public IJavaElement findElementByClassName(String using) {
        List<IJavaElement> elements = this.findElementsByClassName(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("No component found using name: " + using, null);
        }
        return elements.get(0);
    }

    @Override
    public List<IJavaElement> findElementsByClassName(String using) {
        return this.findByCss(":instance-of('" + using + "')");
    }

    protected List<IJavaElement> findByCss(String css) {
        if (!(this.component instanceof Container)) {
            throw new UnsupportedCommandException("findByCss unsupported for non container objects: " + this.component.getClass().getName(), null);
        }
        FindByCssSelector finder = new FindByCssSelector(this, this.driver, this.driver.getImplicitWait());
        return finder.findElements(css);
    }

    @Override
    public List<IJavaElement> findElementsByName(String using) {
        return this.findByCss("#'" + using + "'");
    }

    @Override
    public final String getHandle() {
        if (this instanceof IPseudoElement) {
            try {
                return URLEncoder.encode(((IPseudoElement)((Object)this)).createHandle(), "utf8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.id.toString();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public final IJavaElement findElementByTagName(String using) {
        List<IJavaElement> elements = this.findElementsByTagName(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("No component found using name: " + using, null);
        }
        return elements.get(0);
    }

    @Override
    public List<IJavaElement> findElementsByTagName(String using) {
        return this.findByCss(using);
    }

    @Override
    public final IJavaElement findElementByCssSelector(String using) {
        List<IJavaElement> elements = this.findElementsByCssSelector(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("No component found using selector: `" + using + "'", null);
        }
        return elements.get(0);
    }

    @Override
    public List<IJavaElement> findElementsByCssSelector(String using) {
        if (!(this.component instanceof Container)) {
            throw new UnsupportedCommandException("findElementsByCssSelector unsupported for non container objects: " + this.component.getClass().getName(), new Exception());
        }
        FindByCssSelector finder = new FindByCssSelector(this, this.driver, this.driver.getImplicitWait());
        return finder.findElements(using);
    }

    @Override
    public boolean filterByPseudoClass(String function, Object ... args) {
        if (function.equals("enabled")) {
            return this.isEnabled();
        }
        if (function.equals("disabled")) {
            return !this.isEnabled();
        }
        if (function.equals("displayed")) {
            return this.isDisplayed();
        }
        if (function.equals("hidden")) {
            return !this.isDisplayed();
        }
        if (function.equals("selected") && this.hasAttribue("selected")) {
            return this.isSelected();
        }
        if (function.equals("unselected") && this.hasAttribue("selected")) {
            return !this.isSelected();
        }
        if (function.equals("deselected") && this.hasAttribue("selected")) {
            return !this.isSelected();
        }
        if (function.equals("instance-of")) {
            return this.isInstance((String)args[0]);
        }
        throw new UnsupportedCommandException("Unsupported psuedo class " + function + " component = " + this.component.getClass().getName(), null);
    }

    private boolean isInstance(String classname) {
        try {
            Class<?> c = Class.forName(classname);
            return c.isInstance(this.component);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        String ids = this.id.toString();
        return "@    " + this.component + "\n     id=" + ids + "\n";
    }

    @Override
    public IJavaElement[] getComponents() {
        if (this.component instanceof Container) {
            int i;
            Window[] ownedWindows = new Window[]{};
            if (this.component instanceof Window) {
                ownedWindows = ((Window)this.component).getOwnedWindows();
            }
            Component[] components = ((Container)this.component).getComponents();
            IJavaElement[] r = new IJavaElement[components.length + ownedWindows.length];
            for (i = 0; i < components.length; ++i) {
                r[i] = JavaElementFactory.createElement(components[i], this.driver, this.window);
            }
            for (i = components.length; i < components.length + ownedWindows.length; ++i) {
                r[i] = JavaElementFactory.createElement(ownedWindows[i - components.length], this.driver, this.window);
            }
            return r;
        }
        return new IJavaElement[0];
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJavaElement other = (AbstractJavaElement)obj;
        return !(this.id == null ? other.getId() != null : !this.getHandle().equals(other.getHandle()));
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("call-select")) {
            if (this.marathon_select((String)params[0])) {
                return Arrays.asList(this);
            }
            return Arrays.asList(new IJavaElement[0]);
        }
        if (selector.equals("call-select-by-properties")) {
            if (this.marathon_select(new JSONArray((String)params[0]))) {
                return Arrays.asList(this);
            }
            return Arrays.asList(new IJavaElement[0]);
        }
        throw new UnsupportedCommandException("Pseudo element selector " + selector + " is not applicable for " + this.component.getClass().getName(), null);
    }

    @Override
    public boolean marathon_select(JSONArray jsonArray) {
        throw new UnsupportedCommandException("Select method by properties is not applicable for " + this.component.getClass().getName() + " (" + this.getClass().getName() + ")", null);
    }

    @Override
    public boolean marathon_select(String value) {
        throw new UnsupportedCommandException("Select method is not applicable for " + this.component.getClass().getName() + " (" + this.getClass().getName() + ")", null);
    }

    @Override
    public String createId() {
        this.id = UUID.randomUUID();
        return this.id.toString();
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public void moveto() {
        EventQueueWait.call_noexc(this, "_moveto", new Object[0]);
    }

    public void _moveto() {
        this.driver.getDevices().moveto(this.component);
    }

    @Override
    public void moveto(int xoffset, int yoffset) {
        EventQueueWait.call_noexc(this, "_moveto", xoffset, yoffset);
    }

    public void _moveto(int xoffset, int yoffset) {
        this.driver.getDevices().moveto(this.component, xoffset, yoffset);
    }

    public IJavaAgent getDriver() {
        return this.driver;
    }

    public JavaTargetLocator.JWindow getWindow() {
        return this.window;
    }

    @Override
    public void click(int button, int clickCount, int xoffset, int yoffset) {
        this.verifyCanInteractWithElement();
        EventQueueWait.requestFocus(this.component);
        IDevice mouse = this.driver.getDevices();
        mouse.click(this.component, IDevice.Buttons.getButtonFor(button), clickCount, xoffset, yoffset);
    }

    @Override
    public void buttonDown(int button, int xoffset, int yoffset) {
        this.verifyCanInteractWithElement();
        EventQueueWait.requestFocus(this.component);
        IDevice mouse = this.driver.getDevices();
        mouse.buttonDown(this.component, IDevice.Buttons.getButtonFor(button), xoffset, yoffset);
    }

    @Override
    public void buttonUp(int button, int xoffset, int yoffset) {
        this.verifyCanInteractWithElement();
        EventQueueWait.requestFocus(this.component);
        IDevice mouse = this.driver.getDevices();
        mouse.buttonUp(this.component, IDevice.Buttons.getButtonFor(button), xoffset, yoffset);
    }

    @Override
    public void submit() {
        JComponent tc;
        Object clientProperty;
        if (this.component instanceof JComponent && (clientProperty = (tc = (JComponent)this.component).getClientProperty("marathon.celleditor.parent")) != null) {
            EventQueueWait.call_noexc(clientProperty, "stopEditing", new Object[0]);
        }
    }

    public boolean isVisible() {
        for (Component c = this.component; c != null; c = c.getParent()) {
            if (c instanceof Window) {
                return true;
            }
            if (c.isVisible()) continue;
            return false;
        }
        return true;
    }
}

