/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ChooserHelper {
    public static final Logger LOGGER = Logger.getLogger(ChooserHelper.class.getName());
    private static final String homeDir = ChooserHelper.getRealPath(System.getProperty("user.home", null));
    private static final String cwd = ChooserHelper.getRealPath(System.getProperty("user.dir", null));
    private static final String marathonDir = ChooserHelper.getRealPath(System.getProperty("marathon.project.dir", null));

    private static String getRealPath(String path) {
        if (path == null) {
            return "";
        }
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static File[] decode(String text) {
        ArrayList<File> files = new ArrayList<File>();
        StringTokenizer tokenizer = new StringTokenizer(text, File.pathSeparator);
        while (tokenizer.hasMoreElements()) {
            File file = ChooserHelper.decodeFile((String)tokenizer.nextElement());
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    public static File decodeFile(String path) {
        String prefix = "";
        if (path.startsWith("#M")) {
            prefix = marathonDir;
            path = path.substring(2);
        } else if (path.startsWith("#C")) {
            prefix = cwd;
            path = path.substring(2);
        } else if (path.startsWith("#H")) {
            prefix = homeDir;
            path = path.substring(2);
        }
        return new File(prefix + path.replace('/', File.separatorChar));
    }

    public static String encode(File[] selectedfiles) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < selectedfiles.length; ++i) {
            String encode = ChooserHelper.encode(selectedfiles[i]);
            if (encode != null) {
                buffer.append(encode);
            }
            if (i >= selectedfiles.length - 1) continue;
            buffer.append(File.pathSeparator);
        }
        return buffer.toString();
    }

    public static String encode(File file) {
        try {
            String path = file.getCanonicalPath();
            String prefix = "";
            if (marathonDir != null && path.startsWith(marathonDir)) {
                prefix = "#M";
                path = path.substring(marathonDir.length());
            } else if (cwd != null && path.startsWith(cwd)) {
                prefix = "#C";
                path = path.substring(cwd.length());
            } else if (homeDir != null && path.startsWith(homeDir)) {
                prefix = "#H";
                path = path.substring(homeDir.length());
            }
            return (prefix + path).replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

