/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.sourceforge.marathon.javaagent.EventQueueDevice;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IDevice;
import net.sourceforge.marathon.javaagent.RobotDevice;

public abstract class Device
implements IDevice {
    public static final Logger LOGGER = Logger.getLogger(Device.class.getName());

    public static Device getDevice() {
        return new EventQueueDevice();
    }

    public static Device getDevice(Type t) {
        Logger.getLogger(Device.class.getName()).info("Creating a " + (Object)((Object)t) + " device");
        return t == Type.EVENT_QUEUE ? new EventQueueDevice() : new RobotDevice();
    }

    public static Component getActiveComponent(Component component) {
        final Component comp = component;
        Dimension d = EventQueueWait.exec(new Callable<Dimension>(){

            @Override
            public Dimension call() {
                return comp.getSize();
            }
        });
        int x = d.width / 2;
        int y = d.height / 2;
        return Device.getActiveComponent(component, x, y);
    }

    public static Component getActiveComponent(Component component, int x, int y) {
        Component componentx = SwingUtilities.getDeepestComponentAt(component, x, y);
        if (componentx == null) {
            return component;
        }
        return componentx;
    }

    protected void ensureVisible(Component component, final Rectangle d) {
        final JComponent parent = this.getSwingParent(component);
        if (parent == null) {
            return;
        }
        if (parent != component) {
            Point point = SwingUtilities.convertPoint(component, d.x, d.y, parent);
            d.x = point.x;
            d.y = point.y;
        }
        EventQueueWait.exec(new Runnable(){

            @Override
            public void run() {
                parent.scrollRectToVisible(d);
            }
        });
    }

    private JComponent getSwingParent(Component component) {
        while (component != null && !(component instanceof JComponent)) {
            component = component.getParent();
        }
        return (JComponent)component;
    }

    public static enum Type {
        EVENT_QUEUE,
        ROBOT;

    }
}

