/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.sourceforge.marathon.javaagent.EventQueueWait;

public class DnDHandler {
    public static final Logger LOGGER = Logger.getLogger(DnDHandler.class.getName());
    private Component source;
    private Component dest;
    private Point location;
    private int dropAction;
    private Transferable transferable;

    public DnDHandler(Component source, Component dest, int x, int y, int dropAction) {
        this.source = source;
        this.dest = dest;
        this.dropAction = dropAction;
        this.location = new Point(x, y);
    }

    public Boolean performDrop() {
        try {
            return EventQueueWait.exec(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DnDHandler.this.performInEQ();
                }
            });
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean performInEQ() {
        if (!(this.source instanceof JComponent) || !(this.dest instanceof JComponent)) {
            return false;
        }
        try {
            TransferHandler th = ((JComponent)this.source).getTransferHandler();
            if (th == null) {
                return false;
            }
            Method m = this.getDeclaredMethod(th, "createTransferable", JComponent.class);
            this.transferable = (Transferable)m.invoke((Object)th, this.source);
            if (this.transferable == null) {
                return false;
            }
            m = this.getDeclaredMethod(this.dest, "dropLocationForPoint", Point.class);
            Object dropLocation = m.invoke((Object)this.dest, this.location);
            m = this.getDeclaredMethod(this.dest, "setDropLocation", TransferHandler.DropLocation.class, Object.class, Boolean.TYPE);
            m.invoke((Object)this.dest, dropLocation, null, true);
            this.dest.getDropTarget().dragEnter(this.createDropTargetDragEvent());
            this.dest.getDropTarget().drop(this.createDropTargetDropEvent());
            m = this.getDeclaredMethod(th, "exportDone", JComponent.class, Transferable.class, Integer.TYPE);
            m.invoke((Object)th, this.source, this.transferable, this.dropAction);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private DropTargetDropEvent createDropTargetDropEvent() throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return new DropTargetDropEvent(this.createDropTargetContext(), this.location, this.dropAction, ((JComponent)this.source).getTransferHandler().getSourceActions((JComponent)this.source), true);
    }

    private DropTargetDragEvent createDropTargetDragEvent() throws SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return new DropTargetDragEvent(this.createDropTargetContext(), this.location, this.dropAction, ((JComponent)this.source).getTransferHandler().getSourceActions((JComponent)this.source));
    }

    private DropTargetContext createDropTargetContext() throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor c = DropTargetContext.class.getDeclaredConstructor(DropTarget.class);
        c.setAccessible(true);
        DropTargetContext inst = (DropTargetContext)c.newInstance(this.dest.getDropTarget());
        inst.addNotify(this.createDropTargetContextPeer());
        return inst;
    }

    private DropTargetContextPeer createDropTargetContextPeer() {
        return new DropTargetContextPeer(){

            @Override
            public void setTargetActions(int actions) {
            }

            @Override
            public void rejectDrop() {
            }

            @Override
            public void rejectDrag() {
            }

            @Override
            public boolean isTransferableJVMLocal() {
                return true;
            }

            @Override
            public Transferable getTransferable() {
                return DnDHandler.this.transferable;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return DnDHandler.this.transferable.getTransferDataFlavors();
            }

            @Override
            public int getTargetActions() {
                return DnDHandler.this.dropAction;
            }

            @Override
            public DropTarget getDropTarget() {
                return DnDHandler.this.dest.getDropTarget();
            }

            @Override
            public void dropComplete(boolean success) {
            }

            @Override
            public void acceptDrop(int dropAction) {
            }

            @Override
            public void acceptDrag(int dragAction) {
            }
        };
    }

    private Method getDeclaredMethod(Object th, String n, Class<?> ... classes) {
        Method method = null;
        for (Class<?> klass = th.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            try {
                method = klass.getDeclaredMethod(n, classes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return method;
    }
}

