/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.logging.Logger;

public class EventLogger {
    public static final Logger LOGGER = Logger.getLogger(EventLogger.class.getName());

    public EventLogger(String eventsToLog) {
        long events = this.parse(eventsToLog);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                EventLogger.this.log(event);
            }
        }, events);
    }

    private long parse(String eventsToLog) {
        if (eventsToLog == null || "".equals(eventsToLog)) {
            return 0L;
        }
        String[] eventArray = eventsToLog.split(",");
        long events = 0L;
        for (String event : eventArray) {
            String awtEventName = event.toUpperCase().trim() + "_MASK";
            try {
                long events_v = (Long)AWTEvent.class.getField(awtEventName).get(null);
                events |= events_v;
                LOGGER.info("Enabled event logging for " + awtEventName);
            }
            catch (Throwable t) {
                LOGGER.warning("Event mask not found for " + awtEventName);
            }
        }
        return events;
    }

    public void log(AWTEvent e) {
        LOGGER.info(e.toString());
    }
}

