/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sourceforge.marathon.javaagent.Device;
import net.sourceforge.marathon.javaagent.DnDHandler;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IDevice;
import net.sourceforge.marathon.javaagent.JavaAgentKeys;
import net.sourceforge.marathon.javaagent.KeyboardMap;
import net.sourceforge.marathon.javaagent.KeysMap;
import net.sourceforge.marathon.javaagent.Platform;

public class EventQueueDevice
extends Device {
    public static final Logger LOGGER = Logger.getLogger(EventQueueDevice.class.getName());
    private DeviceState deviceState = new DeviceState();

    @Override
    public void sendKeys(Component component, CharSequence ... keysToSend) {
        for (CharSequence seq : keysToSend) {
            for (int i = 0; i < seq.length(); ++i) {
                this.sendKey(component, seq.charAt(i));
            }
        }
        EventQueueWait.empty();
    }

    @Override
    public void pressKey(Component component, JavaAgentKeys keyToPress) {
        if (keyToPress == JavaAgentKeys.NULL) {
            this.deviceState.resetModifierState(component);
        } else {
            if (this.deviceState.isModifier(keyToPress)) {
                this.deviceState.setKeyStatePressed(component, keyToPress);
            }
            this.dispatchKeyEvent(component, keyToPress, 401, '\uffff');
        }
        EventQueueWait.empty();
    }

    @Override
    public void releaseKey(Component component, JavaAgentKeys keyToRelease) {
        if (this.deviceState.isModifier(keyToRelease)) {
            this.deviceState.setKeyStateReleased(component, keyToRelease);
        }
        this.dispatchKeyEvent(component, keyToRelease, 402, '\uffff');
        EventQueueWait.empty();
    }

    @Override
    public void moveto(final Component component) {
        try {
            Dimension d = EventQueueWait.exec(new Callable<Dimension>(){

                @Override
                public Dimension call() {
                    return component.getSize();
                }
            });
            this.moveto(component, d.width / 2, d.height / 2);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while getting component size", e);
        }
        EventQueueWait.empty();
    }

    @Override
    public void moveto(Component component, int xOffset, int yOffset) {
        int buttons = this.deviceState.getButtons();
        if (component != this.deviceState.getComponent()) {
            if (this.deviceState.getComponent() != null) {
                this.dispatchEvent(new MouseEvent(this.deviceState.getComponent(), 505, System.currentTimeMillis(), this.deviceState.getModifierEx(), this.deviceState.x, this.deviceState.y, 0, false, buttons));
            }
            this.dispatchEvent(new MouseEvent(component, 504, System.currentTimeMillis(), this.deviceState.getModifierEx(), xOffset, yOffset, 0, false, buttons));
        }
        Component source = component;
        int id = 503;
        Point p = new Point(xOffset, yOffset);
        if (buttons != 0) {
            id = 506;
            source = this.deviceState.getDragSource();
            if (source != component) {
                p = SwingUtilities.convertPoint(component, xOffset, yOffset, source);
            }
        }
        int modifierEx = this.deviceState.getModifierEx() | this.deviceState.getButtonMask();
        MouseEvent mouseEvent = new MouseEvent(source, id, System.currentTimeMillis(), modifierEx, p.x, p.y, 0, false, buttons);
        this.dispatchEvent(mouseEvent);
        EventQueueWait.empty();
        this.deviceState.setComponent(component);
        this.deviceState.setMousePosition(xOffset, yOffset);
    }

    @Override
    public void buttonDown(Component component, IDevice.Buttons button, int xoffset, int yoffset) {
        this.dispatchEvent(new MouseEvent(component, 501, System.currentTimeMillis(), this.deviceState.getModifierEx() | 0x400, xoffset, yoffset, 1, false, 1));
        this.deviceState.storeMouseDown(1);
        this.deviceState.setDragSource(component);
        EventQueueWait.empty();
    }

    @Override
    public void buttonUp(Component component, IDevice.Buttons button, int xoffset, int yoffset) {
        if (button.getButton() == 0 && this.handleDnD(component, xoffset, yoffset).booleanValue()) {
            EventQueueWait.empty();
            return;
        }
        this.dispatchEvent(new MouseEvent(component, 502, System.currentTimeMillis(), this.deviceState.getModifierEx(), xoffset, yoffset, 1, false, 1));
        EventQueueWait.empty();
        if (this.deviceState.getComponent() == component) {
            this.dispatchMouseEvent(component, button.getButton() == 2, 1, 1, xoffset, yoffset);
        }
        this.deviceState.storeMouseUp(1);
        this.deviceState.setDragSource(null);
        EventQueueWait.empty();
    }

    private Boolean handleDnD(Component component, int xoffset, int yoffset) {
        int dropAction = this.deviceState.isDnDCopyPressed() ? 1 : 2;
        Logger.getLogger(EventQueueDevice.class.getName()).info("Performing Drop");
        DnDHandler dnd = new DnDHandler(this.deviceState.getDragSource(), component, xoffset, yoffset, dropAction);
        return dnd.performDrop();
    }

    private void sendKey(Component component, char c) {
        component = Device.getActiveComponent(component);
        JavaAgentKeys keys = JavaAgentKeys.getKeyFromUnicode(c);
        if (keys == null) {
            this.dispatchNormal(component, c);
        } else if (keys == JavaAgentKeys.NULL) {
            this.deviceState.resetModifierState(component);
        } else if (this.deviceState.isModifier(keys)) {
            this.deviceState.toggleKeyState(component, keys);
        } else {
            this.pressKey(component, keys);
            if (keys == JavaAgentKeys.SPACE) {
                this.dispatchKeyEvent(component, keys, 400, ' ');
            }
            if (keys == JavaAgentKeys.ENTER) {
                this.dispatchKeyEvent(component, keys, 400, '\n');
            }
            this.releaseKey(component, keys);
        }
    }

    private void dispatchNormal(Component component, char c) {
        KeyboardMap kbMap = new KeyboardMap(c);
        List<CharSequence[]> keysList = kbMap.getKeys();
        if (keysList == null) {
            this.dispatchEvent(new KeyEvent(component, 400, System.currentTimeMillis(), this.deviceState.getModifierEx(), 0, c));
            return;
        }
        for (CharSequence[] keys : keysList) {
            for (CharSequence key : keys) {
                if (this.deviceState.isModifier(key)) {
                    this.pressKey(component, (JavaAgentKeys)key);
                    continue;
                }
                int keyCode = Integer.parseInt(key.toString());
                this.dispatchEvent(new KeyEvent(component, 401, System.currentTimeMillis(), this.deviceState.getModifierEx(), keyCode, c));
            }
            this.dispatchEvent(new KeyEvent(component, 400, System.currentTimeMillis(), this.deviceState.getModifierEx(), 0, c));
            for (int i = keys.length - 1; i >= 0; --i) {
                CharSequence key = keys[i];
                if (this.deviceState.isModifier(key)) {
                    this.releaseKey(component, (JavaAgentKeys)key);
                    continue;
                }
                int keyCode = Integer.parseInt(key.toString());
                this.dispatchEvent(new KeyEvent(component, 402, System.currentTimeMillis(), this.deviceState.getModifierEx(), keyCode, c));
            }
        }
    }

    private void dispatchKeyEvent(final Component component, JavaAgentKeys keyToPress, int id, char c) {
        try {
            Rectangle d = EventQueueWait.exec(new Callable<Rectangle>(){

                @Override
                public Rectangle call() {
                    return component.getBounds();
                }
            });
            this.ensureVisible(component.getParent(), d);
            EventQueueWait.call_noexc(component, "requestFocusInWindow", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("getBounds failed for " + component.getClass().getName(), e);
        }
        KeysMap keysMap = KeysMap.findMap(keyToPress);
        if (keysMap == null) {
            return;
        }
        int m = this.deviceState.getModifierEx();
        int keyCode = keysMap.getCode();
        if (id == 400) {
            keyCode = 0;
        }
        this.dispatchEvent(new KeyEvent(component, id, System.currentTimeMillis(), m, keyCode, c));
        EventQueueWait.empty();
    }

    private void dispatchEvent(final AWTEvent event) {
        LOGGER.info(event.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Component)event.getSource()).dispatchEvent(event);
            }
        });
    }

    private void dispatchMouseEvent(Component component, boolean popupTrigger, int clickCount, int buttons, int x, int y) {
        this.ensureVisible(component, new Rectangle(x, y, 50, 50));
        EventQueueWait.call_noexc(component, "requestFocusInWindow", new Object[0]);
        int modifierEx = this.deviceState.getModifierEx();
        if (component != this.deviceState.getComponent()) {
            if (this.deviceState.getComponent() != null) {
                this.dispatchEvent(new MouseEvent(this.deviceState.getComponent(), 505, System.currentTimeMillis(), modifierEx, this.deviceState.x, this.deviceState.y, 0, popupTrigger, buttons));
            }
            this.dispatchEvent(new MouseEvent(component, 504, System.currentTimeMillis(), modifierEx, x, y, 0, popupTrigger, buttons));
        }
        for (int n = 1; n <= clickCount; ++n) {
            int buttonMask = 1040;
            if (buttons == 3) {
                buttonMask = 4100;
            }
            this.dispatchEvent(new MouseEvent(component, 501, System.currentTimeMillis(), modifierEx | buttonMask, x, y, n, popupTrigger, buttons));
            buttonMask = 16;
            if (buttons == 3) {
                buttonMask = 4;
            }
            this.dispatchEvent(new MouseEvent(component, 502, System.currentTimeMillis(), modifierEx | buttonMask, x, y, n, false, buttons));
            this.dispatchEvent(new MouseEvent(component, 500, System.currentTimeMillis(), modifierEx | buttonMask, x, y, n, false, buttons));
        }
    }

    @Override
    public void click(Component component, IDevice.Buttons button, int clickCount, int xoffset, int yoffset) {
        int b = 1;
        if (button.getButton() == 0) {
            b = 1;
        } else if (button.getButton() == 1) {
            b = 2;
        } else if (button.getButton() == 2) {
            b = 3;
        }
        this.dispatchMouseEvent(component, button.getButton() == 2, clickCount, b, xoffset, yoffset);
        EventQueueWait.empty();
        this.deviceState.setComponent(component);
    }

    public String toString() {
        return "EventQueueDevice [deviceState=" + this.deviceState + "]";
    }

    public class DeviceState {
        private boolean button1Pressed = false;
        private boolean button2Pressed = false;
        private boolean button3Pressed = false;
        private Component component;
        private int y;
        private int x;
        private Component dragSource;
        Map<JavaAgentKeys, Boolean> keyStates = new HashMap<JavaAgentKeys, Boolean>();

        public DeviceState() {
            this.keyStates.put(JavaAgentKeys.SHIFT, false);
            this.keyStates.put(JavaAgentKeys.CONTROL, false);
            this.keyStates.put(JavaAgentKeys.ALT, false);
            this.keyStates.put(JavaAgentKeys.META, false);
        }

        public void toggleKeyState(Component component, JavaAgentKeys key) {
            Boolean pressed = this.keyStates.get(key) == false;
            this.keyStates.put(key, pressed);
            if (pressed.booleanValue()) {
                EventQueueDevice.this.pressKey(component, key);
            } else {
                EventQueueDevice.this.releaseKey(component, key);
            }
        }

        public void setKeyStatePressed(Component component, JavaAgentKeys key) {
            this.keyStates.put(key, true);
        }

        public void setKeyStateReleased(Component component, JavaAgentKeys key) {
            this.keyStates.put(key, false);
        }

        private boolean isModifier(CharSequence keys) {
            return keys == JavaAgentKeys.CONTROL || keys == JavaAgentKeys.ALT || keys == JavaAgentKeys.META || keys == JavaAgentKeys.SHIFT;
        }

        private void resetModifierState(Component component) {
            for (Map.Entry<JavaAgentKeys, Boolean> keyState : this.keyStates.entrySet()) {
                if (!keyState.getValue().booleanValue()) continue;
                this.toggleKeyState(component, keyState.getKey());
            }
        }

        public boolean isShiftPressed() {
            return this.keyStates.get(JavaAgentKeys.SHIFT);
        }

        public boolean isCtrlPressed() {
            return this.keyStates.get(JavaAgentKeys.CONTROL);
        }

        public boolean isAltPressed() {
            return this.keyStates.get(JavaAgentKeys.ALT);
        }

        public boolean isMetaPressed() {
            return this.keyStates.get(JavaAgentKeys.META);
        }

        public int getModifierEx() {
            int modifiersEx = 0;
            if (this.isShiftPressed()) {
                modifiersEx |= 0x41;
            }
            if (this.isCtrlPressed()) {
                modifiersEx |= 0x82;
            }
            if (this.isAltPressed()) {
                modifiersEx |= 0x208;
            }
            if (this.isMetaPressed()) {
                modifiersEx |= 0x104;
            }
            return modifiersEx;
        }

        private void storeMouseDown(int button) {
            if (button == 1) {
                this.button1Pressed = true;
            }
            if (button == 2) {
                this.button2Pressed = true;
            }
            if (button == 3) {
                this.button3Pressed = true;
            }
        }

        private void storeMouseUp(int button) {
            if (button == 1) {
                this.button1Pressed = false;
            }
            if (button == 2) {
                this.button2Pressed = false;
            }
            if (button == 3) {
                this.button3Pressed = false;
            }
        }

        public int getButtons() {
            if (this.button1Pressed) {
                return 1;
            }
            if (this.button2Pressed) {
                return 2;
            }
            if (this.button3Pressed) {
                return 3;
            }
            return 0;
        }

        public int getButtonMask() {
            if (this.button1Pressed) {
                return 1024;
            }
            if (this.button2Pressed) {
                return 2048;
            }
            if (this.button3Pressed) {
                return 4096;
            }
            return 0;
        }

        public void setComponent(Component component) {
            if (this.component != component) {
                this.x = 0;
                this.y = 0;
            }
            this.component = component;
        }

        public Component getComponent() {
            if (this.component == null) {
                Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                if (activeWindow != null) {
                    return activeWindow.getFocusOwner();
                }
                Window[] windows = Window.getWindows();
                if (windows.length > 0) {
                    if (windows[0].getFocusOwner() != null) {
                        return windows[0].getFocusOwner();
                    }
                    return windows[0];
                }
            }
            return this.component;
        }

        private void setMousePosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void setDragSource(Component dragSource) {
            this.dragSource = dragSource;
        }

        public Component getDragSource() {
            return this.dragSource;
        }

        public boolean isDnDCopyPressed() {
            if (Platform.getCurrent().is(Platform.MAC)) {
                return this.isAltPressed();
            }
            return this.isCtrlPressed();
        }

        public String toString() {
            return "DeviceState [shiftPressed=" + this.isShiftPressed() + ", ctrlPressed=" + this.isCtrlPressed() + ", altPressed=" + this.isAltPressed() + ", metaPressed=" + this.isMetaPressed() + ", button1Pressed=" + this.button1Pressed + ", button2Pressed=" + this.button2Pressed + ", button3Pressed=" + this.button3Pressed + ", y=" + this.y + ", x=" + this.x + "]";
        }
    }
}

