/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sourceforge.marathon.javaagent.JavaAgentException;
import net.sourceforge.marathon.javaagent.Wait;

public abstract class EventQueueWait
extends Wait {
    public static final Logger LOGGER = Logger.getLogger(EventQueueWait.class.getName());
    private static final long FOCUS_WAIT_INTERVAL = 50L;
    private static final long FOCUS_WAIT = 1000L;
    private static Component focusComponent;
    private boolean setupDone = false;

    @Override
    public boolean until() {
        final boolean[] condition = new boolean[]{false};
        EventQueueWait.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (!EventQueueWait.this.setupDone) {
                    EventQueueWait.this.setupDone = true;
                    EventQueueWait.this.setup();
                }
                condition[0] = EventQueueWait.this.till();
            }
        });
        return condition[0];
    }

    public void wait_noexc(String message, long timeoutInMilliseconds, long intervalInMilliseconds) {
        try {
            super.wait(message, timeoutInMilliseconds, intervalInMilliseconds);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public abstract boolean till();

    public void setup() {
    }

    public static <X> X exec(final Callable<X> callable) {
        final Object[] result = new Object[]{null};
        final Exception[] exc = new Exception[]{null};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = callable.call();
                }
                catch (Exception e) {
                    exc[0] = e;
                }
            }
        };
        EventQueueWait.invokeAndWait(r);
        if (exc[0] != null) {
            if (exc[0] instanceof InvocationTargetException) {
                Throwable cause = exc[0].getCause();
                exc[0] = cause instanceof Exception ? (Exception)cause : new RuntimeException(cause);
            }
            if (exc[0] instanceof RuntimeException) {
                throw (RuntimeException)exc[0];
            }
            throw new JavaAgentException("Call to invokeAndWait failed: " + exc[0].getMessage(), exc[0]);
        }
        return (X)result[0];
    }

    public static void exec(Runnable runnable) {
        try {
            EventQueueWait.invokeAndWait(runnable);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JavaAgentException("Call to invokeAndWait failed: " + e.getMessage(), e);
        }
    }

    public static <T> T call(final Object o, String f, final Object ... args) throws NoSuchMethodException {
        Method method;
        Class[] params = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            params[i] = args[i] instanceof Integer ? Integer.TYPE : args[i].getClass();
        }
        try {
            method = o.getClass().getMethod(f, params);
        }
        catch (SecurityException e1) {
            throw new JavaAgentException("Method " + f + " could not be found: " + e1.getMessage(), e1);
        }
        final Object[] r = new Object[]{null};
        EventQueueWait.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                boolean accessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    r[0] = method.invoke(o, args);
                }
                catch (Exception e) {
                    r[0] = e;
                }
                finally {
                    method.setAccessible(accessible);
                }
            }
        });
        if (r[0] instanceof InvocationTargetException) {
            r[0] = ((InvocationTargetException)r[0]).getCause();
        }
        if (r[0] instanceof RuntimeException) {
            throw (RuntimeException)r[0];
        }
        if (r[0] instanceof Exception) {
            throw new RuntimeException(((Exception)r[0]).getMessage(), (Exception)r[0]);
        }
        return (T)r[0];
    }

    public static void empty() {
        new EventQueueWait(){

            @Override
            public boolean till() {
                return true;
            }
        }.wait("Waiting for the EventQueue to be empty");
    }

    public static void requestFocus(final Component c) {
        if (EventQueue.isDispatchThread()) {
            if (!c.requestFocusInWindow()) {
                EventQueueWait.generateFocusEvents(c);
            }
            return;
        }
        try {
            new EventQueueWait(){

                @Override
                public void setup() {
                    c.requestFocusInWindow();
                    if (!c.isFocusOwner()) {
                        c.requestFocusInWindow();
                    }
                }

                @Override
                public boolean till() {
                    if (!c.requestFocusInWindow()) {
                        EventQueueWait.generateFocusEvents(c);
                        return true;
                    }
                    Window w = SwingUtilities.windowForComponent(c);
                    if (w != null) {
                        c.requestFocusInWindow();
                        Component f = w.getFocusOwner();
                        return this.focused(c, f) || !c.isFocusable();
                    }
                    return false;
                }

                private boolean focused(Component c2, Component f) {
                    if (f == c2) {
                        return true;
                    }
                    if (c2 instanceof Container) {
                        Component[] cs;
                        for (Component component : cs = ((Container)c2).getComponents()) {
                            if (!this.focused(component, f)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            }.wait("Waiting for the component to receive focus", 1000L, 50L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        focusComponent = c;
    }

    private static void generateFocusEvents(Component c) {
        if (c == focusComponent || !c.isFocusable()) {
            return;
        }
        if (focusComponent != null) {
            EventQueueWait.dispatchEvent(new FocusEvent(focusComponent, 1005, false, c));
        }
        EventQueueWait.dispatchEvent(new FocusEvent(c, 1004, false, focusComponent));
    }

    private static void dispatchEvent(final AWTEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Component)event.getSource()).dispatchEvent(event);
            }
        });
    }

    public static void waitTillDisabled(final Component c) {
        new EventQueueWait(){

            @Override
            public boolean till() {
                return !c.isEnabled();
            }
        }.wait("Waiting for the component to be disabled", 1000L, 50L);
    }

    public static void waitTillInvisibled(final Component c) {
        new EventQueueWait(){

            @Override
            public boolean till() {
                return !c.isVisible();
            }
        }.wait("Waiting for the component to be hidden", 1000L, 50L);
    }

    public static void waitTillShown(final Component c) {
        new EventQueueWait(){

            @Override
            public boolean till() {
                return c.isShowing();
            }
        }.wait("Waiting for the component to be shown", 1000L, 50L);
    }

    private static void invokeAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("invokeAndWait failed: " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("invokeAndWait failed: " + e.getMessage(), e);
            }
        }
    }

    public static <T> T call_noexc(Object o, String f, Object ... args) {
        try {
            return EventQueueWait.call(o, f, args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

