/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sourceforge.marathon.javaagent.Device;
import net.sourceforge.marathon.javaagent.IDevice;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JOptions;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.css.FindByCssSelector;
import org.json.JSONObject;

public class JavaAgent
implements IJavaAgent {
    public static final Logger LOGGER = Logger.getLogger(JavaAgent.class.getName());
    private static final String VERSION = "1.0";
    private IDevice devices;
    private JavaTargetLocator targetLocator;
    private JOptions options;
    private long implicitWait;

    public JavaAgent() {
        this(Device.Type.EVENT_QUEUE);
    }

    public JavaAgent(Device.Type type) {
        this.devices = Device.getDevice(type);
        this.targetLocator = new JavaTargetLocator(this);
        this.options = new JOptions(this);
    }

    @Override
    public IDevice getDevices() {
        return this.devices;
    }

    @Override
    public String getTitle() {
        return this.targetLocator.getTitle();
    }

    @Override
    public Collection<String> getWindowHandles() {
        return this.targetLocator.getWindowHandles();
    }

    @Override
    public String getWindowHandle() {
        return this.targetLocator.getWindowHandle();
    }

    @Override
    public JavaTargetLocator switchTo() {
        return this.targetLocator;
    }

    @Override
    public JOptions manage() {
        return this.options;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getName() {
        return "javadriver";
    }

    @Override
    public void deleteWindow() {
        this.targetLocator.deleteWindow();
    }

    @Override
    public IJavaElement findElement(String id) {
        return this.targetLocator.findElement(id);
    }

    @Override
    public IJavaElement getActiveElement() {
        return this.targetLocator.getActiveElement();
    }

    @Override
    public void quit() {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Runtime.getRuntime().halt(1);
                        return null;
                    }
                });
            }
        }, 10L);
    }

    @Override
    public JavaTargetLocator.JWindow getWindow(String windowHandle) {
        return this.targetLocator.getWindowForHandle(windowHandle);
    }

    @Override
    public JavaTargetLocator.JWindow getCurrentWindow() {
        return this.targetLocator.getCurrentWindow();
    }

    @Override
    public IJavaElement findElementByTagName(String using) {
        List<IJavaElement> elements = this.findElementsByTagName(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("No component found using name: " + using, null);
        }
        return elements.get(0);
    }

    @Override
    public List<IJavaElement> findElementsByTagName(String using) {
        if (using.equals("#fileDialog")) {
            JavaTargetLocator.JWindow topContainer = this.targetLocator.getTopContainer();
            return Arrays.asList(topContainer.findFileDialogElement(this.targetLocator.getFileDialogContainer()));
        }
        return this.findByCss(using);
    }

    @Override
    public IJavaElement findElementByName(String using) {
        List<IJavaElement> elements = this.findElementsByName(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("No component found using name: " + using, null);
        }
        return elements.get(0);
    }

    @Override
    public List<IJavaElement> findElementsByName(String using) {
        return this.findByCss("#'" + using + "'");
    }

    @Override
    public IJavaElement findElementByCssSelector(String using) {
        List<IJavaElement> elements = this.findElementsByCssSelector(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("No component found using selector: `" + using + "'", null);
        }
        return elements.get(0);
    }

    @Override
    public List<IJavaElement> findElementsByCssSelector(String using) {
        Window window = this.targetLocator.getTopContainer().getWindow();
        IJavaElement je = JavaElementFactory.createElement(window, this, this.targetLocator.getTopContainer());
        FindByCssSelector finder = new FindByCssSelector(je, this, this.implicitWait);
        return finder.findElements(using);
    }

    @Override
    public IJavaElement findElementByClassName(String using) {
        List<IJavaElement> elements = this.findElementsByClassName(using);
        if (elements.size() == 0) {
            throw new NoSuchElementException("No component found using selector: `" + using + "'", null);
        }
        return elements.get(0);
    }

    @Override
    public List<IJavaElement> findElementsByClassName(String using) {
        return this.findByCss(":instance-of('" + using + "')");
    }

    protected List<IJavaElement> findByCss(String css) {
        Window window = this.targetLocator.getTopContainer().getWindow();
        IJavaElement je = JavaElementFactory.createElement(window, this, this.targetLocator.getTopContainer());
        FindByCssSelector finder = new FindByCssSelector(je, this, this.implicitWait);
        return finder.findElements(css);
    }

    @Override
    public JSONObject getWindowProperties() {
        return this.targetLocator.getWindowProperties();
    }

    @Override
    public void setImplicitWait(long implicitWait) {
        this.implicitWait = implicitWait;
    }

    @Override
    public IJavaElement findElement(Component component) {
        return this.targetLocator.getTopContainer().findElement(component);
    }

    @Override
    public byte[] getScreenShot() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Dimension windowSize = Toolkit.getDefaultToolkit().getScreenSize();
            BufferedImage bufferedImage = new Robot().createScreenCapture(new Rectangle(0, 0, windowSize.width, windowSize.height));
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    @Override
    public long getImplicitWait() {
        return this.implicitWait;
    }
}

