/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.EventLogger;
import net.sourceforge.marathon.javaagent.JavaElementPropertyAccessor;
import net.sourceforge.marathon.javaagent.server.JavaServer;

public class JavaAgentHook {
    public static final Logger LOGGER = Logger.getLogger(JavaAgentHook.class.getName());
    private static EventLogger eventLogger;
    protected static String windowTitle;

    public static void premain(String args) throws Exception {
        JavaElementPropertyAccessor.InternalFrameMonitor.init();
        if (args == null || args.trim().length() <= 0) {
            throw new Exception("Port number not specified");
        }
        final int port = Integer.parseInt(args.trim());
        String eventsToLog = System.getProperty("marathon.logevents");
        new EventLogger(eventsToLog);
        windowTitle = System.getProperty("start.window.title", "");
        AWTEventListener listener = new AWTEventListener(){
            boolean done = false;

            @Override
            public void eventDispatched(AWTEvent event) {
                if (this.done) {
                    return;
                }
                LOGGER.info("Checking for window: " + Thread.currentThread());
                if (!"".equals(windowTitle) && !this.isValidWindow()) {
                    LOGGER.info("Not a valid window");
                    return;
                }
                this.done = true;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            LOGGER.info("JavaVersion: " + System.getProperty("java.version"));
                            LOGGER.info("JavaHome: " + System.getProperty("java.home"));
                            Charset utf8 = Charset.forName("utf-8");
                            if (!Charset.defaultCharset().equals(utf8)) {
                                LOGGER.warning("Application is using a non-utf8 charset. Marathon might cause issues while playing");
                            }
                            JavaServer server = new JavaServer(port, true);
                            server.start(0);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            }

            private boolean isValidWindow() {
                Window[] windows;
                for (Window window : windows = Window.getWindows()) {
                    if (!(windowTitle.startsWith("/") ? this.getTitle(window).matches(windowTitle.substring(1)) : this.getTitle(window).equals(windowTitle))) continue;
                    return true;
                }
                return false;
            }

            private String getTitle(Window window) {
                if (window instanceof Dialog) {
                    return ((Dialog)window).getTitle();
                }
                if (window instanceof Frame) {
                    return ((Frame)window).getTitle();
                }
                return window.getClass().getName();
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 68L);
    }
}

