/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellEditor;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.IJavaElementFinder;
import net.sourceforge.marathon.javaagent.JProgressBarJavaElement;
import net.sourceforge.marathon.javaagent.JavaElement;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.components.DefaultEditorJavaElement;
import net.sourceforge.marathon.javaagent.components.JColorChooserJavaElement;
import net.sourceforge.marathon.javaagent.components.JComboBoxJavaElement;
import net.sourceforge.marathon.javaagent.components.JEditorPaneJavaElement;
import net.sourceforge.marathon.javaagent.components.JFileChooserJavaElement;
import net.sourceforge.marathon.javaagent.components.JListJavaElement;
import net.sourceforge.marathon.javaagent.components.JMenuItemJavaElement;
import net.sourceforge.marathon.javaagent.components.JSliderJavaElement;
import net.sourceforge.marathon.javaagent.components.JSpinnerJavaElement;
import net.sourceforge.marathon.javaagent.components.JSplitPaneJavaElement;
import net.sourceforge.marathon.javaagent.components.JTabbedPaneJavaElement;
import net.sourceforge.marathon.javaagent.components.JTableHeaderJavaElement;
import net.sourceforge.marathon.javaagent.components.JTableJavaElement;
import net.sourceforge.marathon.javaagent.components.JTextComponentJavaElement;
import net.sourceforge.marathon.javaagent.components.JToggleButtonJavaElement;
import net.sourceforge.marathon.javaagent.components.JTreeEditingContainerJavaElement;
import net.sourceforge.marathon.javaagent.components.JTreeJavaElement;

public class JavaElementFactory {
    public static final Logger LOGGER = Logger.getLogger(JavaElementFactory.class.getName());
    private static LinkedList<IJavaElementFinder> entries = new LinkedList();

    public static IJavaElement createElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        if (component == null) {
            throw new RuntimeException("Calling createElement with a null component is not supported");
        }
        IJavaElement found = window.findElementFromMap(component);
        if (found != null) {
            return found;
        }
        Class<? extends IJavaElement> klass = JavaElementFactory.get(component);
        if (klass == null) {
            return new JavaElement(component, driver, window);
        }
        try {
            Constructor<? extends IJavaElement> constructor = klass.getConstructor(Component.class, IJavaAgent.class, JavaTargetLocator.JWindow.class);
            IJavaElement newInstance = constructor.newInstance(component, driver, window);
            return newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException("createElement failed", e);
        }
    }

    public static void reset() {
        JavaElementFactory.add(Component.class, JavaElement.class);
        JavaElementFactory.add(JList.class, JListJavaElement.class);
        JavaElementFactory.add(JTabbedPane.class, JTabbedPaneJavaElement.class);
        JavaElementFactory.add(JComboBox.class, JComboBoxJavaElement.class);
        JavaElementFactory.add(JTable.class, JTableJavaElement.class);
        JavaElementFactory.add(JTableHeader.class, JTableHeaderJavaElement.class);
        JavaElementFactory.add(JTree.class, JTreeJavaElement.class);
        JavaElementFactory.add(JToggleButton.class, JToggleButtonJavaElement.class);
        JavaElementFactory.add(JSpinner.class, JSpinnerJavaElement.class);
        JavaElementFactory.add(JProgressBar.class, JProgressBarJavaElement.class);
        JavaElementFactory.add(JSplitPane.class, JSplitPaneJavaElement.class);
        JavaElementFactory.add(JTextComponent.class, JTextComponentJavaElement.class);
        JavaElementFactory.add(DefaultTreeCellEditor.EditorContainer.class, JTreeEditingContainerJavaElement.class);
        JavaElementFactory.add(JEditorPane.class, JEditorPaneJavaElement.class);
        JavaElementFactory.add(JMenuItem.class, JMenuItemJavaElement.class);
        JavaElementFactory.add(JSlider.class, JSliderJavaElement.class);
        JavaElementFactory.add(JSpinner.class, JSpinnerJavaElement.class);
        JavaElementFactory.add(JSpinner.DefaultEditor.class, DefaultEditorJavaElement.class);
        JavaElementFactory.add(JColorChooser.class, JColorChooserJavaElement.class);
        JavaElementFactory.add(JFileChooser.class, JFileChooserJavaElement.class);
    }

    public static Class<? extends IJavaElement> get(Component component) {
        for (IJavaElementFinder entry : entries) {
            Class<? extends IJavaElement> k = entry.get(component);
            if (k == null) continue;
            return k;
        }
        return null;
    }

    public static void add(Class<? extends Component> component, Class<? extends IJavaElement> javaelement) {
        JavaElementFactory.add(new InstanceCheckFinder(component, javaelement));
    }

    public static void add(IJavaElementFinder e) {
        entries.addFirst(e);
    }

    static {
        JavaElementFactory.reset();
    }

    private static class InstanceCheckFinder
    implements IJavaElementFinder {
        private Class<? extends Component> componentKlass;
        private Class<? extends IJavaElement> javaElementKlass;

        public InstanceCheckFinder(Class<? extends Component> componentKlass, Class<? extends IJavaElement> javaElementKlass) {
            this.componentKlass = componentKlass;
            this.javaElementKlass = javaElementKlass;
        }

        @Override
        public Class<? extends IJavaElement> get(Component component) {
            if (this.componentKlass.isInstance(component)) {
                return this.javaElementKlass;
            }
            return null;
        }
    }
}

